#ifndef _ygWorld_h_
#define _ygWorld_h_

#include "ygNode.h"
class ygUser;


#define YG_ISECT_ALLMASK	(1 << 0)
#define YG_ISECT_WALLMASK	(1 << 1)
#define YG_ISECT_FLOORMASK	(1 << 2)
#define YG_ISECT_GRABMASK	(1 << 3)
#define YG_ISECT_TRIGGERMASK	(1 << 4)



class ygWorld
	{
	public:
	 ygWorld(void);
	 ~ygWorld(void);
	 void frame(void);
	 void reset(void);
	 void scheduleMessage(ygMessage&);
	 void createRoot(void);
	 void setRoot(ygNode*);
	 ygNode * root(void) const { return root_; }
	 ygNode * localRoot(void) const { return localRoot_; }
	 class pfScene* pfscene(void) const;
	 void setClip(float near,float far);
	 void setSkyColor(const pfVec3&);
	 void setBackgroundMode (int mode);
	 void setEarthSkyGradient (const pfVec3&,const pfVec3&,const pfVec3&,const pfVec3&,const pfVec3&);
	 void setHorizonAngle (float angle);
	 void setGroundHeight (float height);
	 void fogOff(void);
	 void setFog(int fogtype,const pfVec3& color,float onset,float opaque);
	 void addUser(ygUser*);
	 void removeUser(ygUser*);
	 int numUsers(void) const;
	 ygUser* user(int) const;
	 ygNode* viewer(void) const;
	 void unlinkLocalScene(void);
	 static float FrameTime;
	 static float FrameDeltaTime;
	 static int FrameNumber;
	 static ygWorld* World;
	 class pfShadow * pfshadow(void) const;
	 class pfVolFog * pfvolfog (void) const;
	 void addShadowCaster (ygNode * node);
	 void updateShadows (void);
	private:
	 void sendMessage(ygMessage&);
	 void unlinkTree(ygNode*);
	 ygNode *root_, *localRoot_;
	 struct _ygWorldPrivateData * p_;
	};


#endif
