// Description: creates a wand for the user and adds it to the user wand list
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> this node serves no purpose other than as a base class for <a href="ygCAVEWand.html">ygCAVEWand</a>
//</ul>
//
// Category: User
// Author: Dave Pape
//           11/01/01
// Revision: 01/10/03 Alex Hill - added flag message
//
#include <vector>
#include "ygNetKeys.h"
#include "ygUser.h"
#include "ygWorld.h"
#include "ygWand.h"

using namespace std;

extern "C" ygNode* construct_ygWand(const char* name,bool master) { return new ygWand(name,master); }

struct _ygWandPrivateData
	{
	vector<ygString> flags, newFlags;
	ygUser* user;
	ygString netString;
	};


ygWand::ygWand(const char* name,bool master) : ygNode(name,master)
	{
	setClassName("ygWand",true);
	p_ = new struct _ygWandPrivateData;
	p_->user = NULL;
	//distribute flags generated by derived nodes
	addNetKey("flags", &p_->netString, YG_NET_STRING);
	}


void ygWand::reset(void)
	{
	//find first user above this node
	p_->user = ygUser::findUserAncestor(this);
	//if found add this wand to the wand list of the user
	if (p_->user)
		p_->user->addWand(this);
	ygNode::reset();
	}


void ygWand::message(const ygMessage& msg)
	{
	//generate a wand flag
	if (msg == "flag")
		{
		if (msg.args.size() == 1)
			setFlag(msg.args[0]);
		else
			msg.error(name(),"(wrong number of arguments)");
		}
	else
		ygNode::message(msg);
	}

	
void ygWand::app(void)
	{
	//if the number of flags has changed
	if ((p_->flags.size() > 0) || (p_->newFlags.size() > 0))
		{
		int i;
		p_->flags = p_->newFlags;
		p_->newFlags.clear();
		//if net master then generate flag events
		if (isNetMaster())
			{
			p_->netString.clear();
			for (i = 0; i < p_->flags.size(); i++)
				{
				p_->netString += p_->flags[i];
				p_->netString += " ";
				}
			netKeyChanged("flags");
			}
		}
	ygNode::app();
	}


int ygWand::numFlags(void) const
	{
	return p_->flags.size();
	}


bool ygWand::getFlag(int num,ygString& flag) const
	{
	if ((num >= 0) && (num < numFlags()))
		{
		flag = p_->flags[num];
		return true;
		}
	else
		return false;
	}


const ygUser* ygWand::user(void) const
	{
	if (!p_->user)
		p_->user = ygUser::findUserAncestor((ygNode*)this);
	return p_->user;
	}


void ygWand::setFlag(const ygString& flag)
	{
	p_->newFlags.push_back(flag);
	//gererate events for flags produced by derived nodes
	eventOccurred(flag);
	}


void ygWand::acceptNetKey(const ygString& key)
	{
	if (key == "flags")
		{
		ygString *f;
		int i=0;
		while (f = p_->netString.nextToken(" ",&i))
			{
			setFlag(*f);
			delete f;
			}
		}
	else
		ygNode::acceptNetKey(key);
	}
