#ifndef __ygVolume_h__
#define __ygVolume_h__

#include <Performer/pr/pfLinMath.h>
#include <Performer/pr/pfGeoMath.h>

enum
	{
	YGVOL_INFINITE,
	YGVOL_POINT,
	YGVOL_BOX,
	YGVOL_SPHERE,
	YGVOL_CYLINDER
	};


class ygVolume
		{
		public:
		 ygVolume(void);
		 virtual ~ygVolume(void);
		 virtual float distance(const pfVec3 &v) const;
		 virtual float sqrDistance(const pfVec3 &) const =0;
		 virtual int contains(const pfVec3 &) const =0;
		 virtual int isect(const pfSeg *,float *,float *) const =0;
		 virtual void makeEmpty(void)=0;
		 virtual void extendBy(const pfVec3 &)=0;
		 virtual void extendBy(const pfBox *)=0;
		 virtual void extendBy(const pfSphere *)=0;
		 virtual void extendBy(const pfCylinder *)=0;
		 virtual void around(const pfVec3 *,int)=0;
		 virtual void around(const pfBox **,int)=0;
		 virtual void around(const pfSphere **,int)=0;
		 virtual void around(const pfCylinder **,int)=0;
		 virtual float size(void) const =0;
		 virtual int volumeType(void) const =0;
		protected:
		};

#endif
