#ifndef _ygUtil_h_
#define _ygUtil_h_

#include <Performer/pr/pfLinMath.h>
#include <iostream>
#include "ygString.h"

inline std::ostream& operator<< (std::ostream& s, const pfVec2& v)
		{ return s << "(" << v[0] << ", " << v[1] << ")"; }
inline std::ostream& operator<< (std::ostream& s, const pfVec3& v)
		{ return s << "(" << v[0] << ", " << v[1] << ", " << v[2] << ")"; }
inline std::ostream& operator<< (std::ostream& s, const pfVec4& v)
		{ return s << "(" << v[0] << ", " << v[1] << ", " << v[2]
				 << ", " << v[3] << ")"; }
inline std::ostream& operator<< (std::ostream& s, const pfMatrix& m)
		{ return s << "[ " << m[0][0] << " " << m[0][1] << " " << m[0][2] << " " << m[0][3] << "]\n"
			<< "[ " << m[1][0] << " " << m[1][1] << " " << m[1][2] << " " << m[1][3] << "]\n"
			<< "[ " << m[2][0] << " " << m[2][1] << " " << m[2][2] << " " << m[2][3] << "]\n"
			<< "[ " << m[3][0] << " " << m[3][1] << " " << m[3][2] << " " << m[3][3] << "]\n"; }


extern bool ygFindFileInYgPath(const ygString& filename, ygString& returnPath);
extern bool ygFindFile(const ygString& filename, const ygString& searchPath,
		ygString& returnPath);
extern float ygGetTime(void);
extern double ygGetTimeD(void);

extern class ygVolume* ygParseVolumeMessage(const class ygMessage& description);
extern void ygWriteVolumeMessage(class ygVolume* vol, ygString& str);
extern class pfGeoSet * ygCreateVolumeGeoset(class ygVolume * vol, int style);

enum {
	YG_STYLE_WIREFRAME,
	YG_STYLE_SOLID
	};


extern void ygPrePFInit(void);
extern void ygPrePFConfig(void);

extern void ygPrintSceneGraph(class ygNode * node);

typedef void * (*ygThreadFuncPtr) (void *);
extern bool ygCreateThread(ygThreadFuncPtr,void *);

extern bool ygServerMode(void);
extern void ygSetServerMode(bool val=true);

extern void ygMakeValidNodeName(ygString& name);

#endif
