// Revision: 11/01/01 Dave Pape

#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <sys/time.h>
#include <Performer/pf.h>
#include <Performer/pfdu.h>
#include "ygNode.h"
#include "ygFileServer.h"
#include "ygDSOLoader.h"
#include "ygUtil.h"

char * ygVersion = "Ygdrasil Version 0.1.11 - compiled " __DATE__;

using namespace std;


bool ygFindFileInYgPath(const ygString& filename, ygString& returnPath)
	{
	static ygString searchPath;
	if (searchPath.length() < 1)
		{
		if (getenv("YG_PATH"))
			searchPath = getenv("YG_PATH");
		else
			searchPath = ".";
		}
	return ygFindFile(filename,searchPath,returnPath);
	}


bool ygFindFile(const ygString& filename, const ygString& searchPath,
	               ygString& returnPath)
	{
	ygString testName(filename);
	ygString *dir;
	int i=0;
	struct stat statbuf;
	if (stat(testName.c_str(),&statbuf) == 0)
		{
		returnPath = testName;
		return true;
		}
	while (dir = searchPath.nextToken(":",&i))
		{
		testName = *dir;
		delete dir;
		testName += "/";
		testName += filename;
		if (stat(testName.c_str(),&statbuf) == 0)
			{
			returnPath = testName;
			return true;
			}
		}
	return false;
	}


static bool ygTimeInitted=false;
static struct timeval ygTimeStart;
static float ygTimeMicrosecondF=1.0f/1000000.0f;
static double ygTimeMicrosecondD=1.0/1000000.0;

float ygGetTime(void)
	{
	struct timeval t;
	if (!ygTimeInitted)
		{
		gettimeofday(&ygTimeStart,NULL);
		ygTimeInitted = true;
		}
	gettimeofday(&t,NULL);
	return (t.tv_sec - ygTimeStart.tv_sec) +
		(t.tv_usec - ygTimeStart.tv_usec) * ygTimeMicrosecondF;
	}

double ygGetTimeD(void)
	{
	struct timeval t;
	if (!ygTimeInitted)
		{
		gettimeofday(&ygTimeStart,NULL);
		ygTimeInitted = true;
		}
	gettimeofday(&t,NULL);
	return (t.tv_sec - ygTimeStart.tv_sec) +
		(t.tv_usec - ygTimeStart.tv_usec) * ygTimeMicrosecondD;
	}


#include "ygSimpleTransform.h"
#include "ygTransform.h"
#include "ygSwitch.h"
#include "ygSelector.h"
#include "ygSpace.h"
#include "ygEnvironment.h"
#include "ygLight.h"
#include "ygObject.h"
#include "ygSound.h"
#include "ygUser.h"
#include "ygWand.h"
#include "ygNavigator.h"

static void debugNode(ygNode * node)
	{
	if (node->isOfClass("ygSimpleTransform"))
		{
		pfMatrix mat;
		pfCoord coord;
		ygSimpleTransform *xnode = (ygSimpleTransform*)node;
		xnode->getMatrix(mat);
		mat.getOrthoCoord(&coord);
		printf("  xyz(%.2f %.2f %.2f) hpr(%.2f %.2f %.2f)",
			coord.xyz[0],coord.xyz[1],coord.xyz[2],
			coord.hpr[0],coord.hpr[1],coord.hpr[2]);
		}
	else if (node->isOfClass("ygTransform"))
		{
		pfMatrix mat;
		pfCoord coord;
		ygTransform *xnode = (ygTransform*)node;
		xnode->getMatrix(mat);
		mat.getOrthoCoord(&coord);
		printf("  xyz(%.2f %.2f %.2f) hpr(%.2f %.2f %.2f)",
			coord.xyz[0],coord.xyz[1],coord.xyz[2],
			coord.hpr[0],coord.hpr[1],coord.hpr[2]);
		}
	else if (node->isOfClass("ygSwitch"))
		{
		ygSwitch *xnode = (ygSwitch*)node;
		printf("  on:%d",xnode->isOn());
		}
	else if (node->isOfClass("ygSelector"))
		{
		ygSelector *xnode = (ygSelector*)node;
		if (xnode->selected())
			printf("  selected:%s",xnode->selected()->name().c_str());
		}
	else if (node->isOfClass("ygSpace"))
		{
		ygSpace *xnode = (ygSpace*)node;
		ygString volmsg;
		ygWriteVolumeMessage((ygVolume*)xnode->volume(),volmsg);
		cout << " " << volmsg;
		}
	if (node->isOfClass("ygEnvironment"))
		{
		ygEnvironment *xnode = (ygEnvironment*)node;
		pfVec3 sky = xnode->skyColor();
		printf(" clip(%.2f %.2f) sky(%.2f %.2f %.2f)",xnode->nearClip(),
			xnode->farClip(),sky[0],sky[1],sky[2]);
		}
	if (node->isOfClass("ygLight"))
		{
		ygLight *xnode = (ygLight*)node;
		printf(" on:%d",xnode->isOn());
		}
	if (node->isOfClass("ygObject"))
		{
		ygObject *xnode = (ygObject*)node;
		printf(" file:%s",xnode->filename().c_str());
		}
	if (node->isOfClass("ygSound"))
		{
		ygSound *xnode = (ygSound*)node;
		printf(" on:%d",xnode->isPlaying());
		}
	if (node->isOfClass("ygUser"))
		{
		ygUser *xnode = (ygUser*)node;
		if (xnode->navigator())
			cout << " nav:" << xnode->navigator()->name();
		if (xnode->head())
			cout << " head:" << xnode->head()->name();
		int i;
		for (i=0; i<xnode->numWands(); i++)
			cout << " wand:" << xnode->wand(i)->name();
		}
	if (node->isOfClass("ygWand"))
		{
		ygWand *xnode = (ygWand*)node;
		if (xnode->user())
			cout << " user:" << xnode->user()->name();
		}
	cout << endl;
	}

static void printTree(ygNode * node, int depth)
	{
	if (node)
		{
		int i;
		for (i=0; i < depth; i++)
			cout << "  ";
		cout << node->className() << ":" << node->name();
		debugNode(node);
		for (i=0; i < node->numChildren(); i++)
			printTree(node->child(i),depth+1);
		}
	}


void ygPrintSceneGraph(ygNode * node)
	{
	cout << "Scene Graph:\n";
	printTree(node, 1);
	}


static bool ygServerMode_ = false;

bool ygServerMode(void)
	{
	return ygServerMode_;
	}


void ygSetServerMode(bool val)
	{
	ygServerMode_ = val;
	}


void ygMakeValidNodeName(ygString& name)
	{
	char * s = name.c_str();
	int i;
	for (i=0; i < name.length(); i++)
		if (!isalnum(s[i]))
			s[i] = '_';
	}


void ygPrePFInit(void)
	{
#ifdef __sgi
	extern void ygSGIIOStreamInit(void);
	ygSGIIOStreamInit();
#endif
	cout << ygVersion << endl;
	}


void ygPrePFConfig(void)
	{
	ygFileServer::initialize();
	ygDSOLoader::init();
	if (getenv("YG_PATH"))
		pfFilePath(getenv("YG_PATH"));
	pfdInitConverter("pfb");
	if (getenv("YG_PF_DBASE_CONVERTERS"))
		{
		ygString extensions(getenv("YG_PF_DBASE_CONVERTERS"));
		ygString *token;
		int i;
		while (token = extensions.nextToken(" \t",&i))
			{
			pfdInitConverter(token->c_str());
			delete token;
			}
		}
/* These two options were needed for Alive on the Grid */
	if (getenv("YG_PF_FORK_COMPUTE"))
		pfMultiprocess(PFMP_FORK_CULL | PFMP_FORK_COMPUTE);
	if (getenv("YG_PF_INIT_SMOKES"))
		pfuInitSmokes();
	}


#ifdef __sgi

bool ygCreateThread(ygThreadFuncPtr func,void *arg)
	{
	pid_t p = sproc((void(*)(void*))func,PR_SADDR,arg);
	if (p <= 0)
		{
		perror("ygCreateThread: sproc");
		return false;
		}
	return true;
	}

#else

#include <CAVERN.hxx>

bool ygCreateThread(ygThreadFuncPtr func,void *arg)
	{
	CAVERNts_thread_c *thread = new CAVERNts_thread_c;
	int retval = thread->create(func,arg);
	return (retval == 0);
	}

#endif
