#ifndef _ygTokenStream_h_
#define _ygTokenStream_h_

#include <stdio.h>
#include <stack>
#include "ygString.h"

class ygTokenStream
	{
	public:
	 ygTokenStream(const ygString&);
	 ~ygTokenStream(void);
	 bool next(ygString &string);
	 const ygString& filename(void) const { return filename_; }
	 int linenumber(void) const { return lineNumber_; }
	 void pushback(const ygString& string);
	private:
	 bool getNextLine(void);
	 bool readNextToken(ygString& token);
	 int nextChar(void);
	 void pushbackChar(int c);
	 ygString filename_;
	 FILE *fp_;
	 char linebuf_[1024];
	 char *linebufptr_;
	 int lineNumber_;
	 std::stack<ygString*> tokenStack_;
	 std::stack<int> charStack_;
	 bool noPreprocessor_;
	};

#endif
