#ifndef _ygTexture_h
#define _ygTexture_h

#include <Performer/pf/pfGeode.h>
#include "ygTransform.h"

class ygTexture : public ygTransform
{
	public:
	 ygTexture(const char *name, bool master = true);
	 ~ygTexture(void);
	 virtual void reset(void);
	 virtual void message(const ygMessage &);
		void setWall(bool val=true);
		void setFloor(bool val=true);
		void setDraw(bool val=true);
		void showLocal(bool val=true);
		void setTexture(const ygString&);
	protected:
	 virtual void acceptNetKey(const ygString&);
	private:
	 void createGeometry(void);
	 uint isectMask;
	 bool drawn;
	 bool cache;
	 bool show;
	 pfGeode* geode;
	 pfGeoSet* geoset;
	 pfGeoState* gstate;
	 ygString filename;
};

extern "C" ygNode* construct_ygTexture(const char*,bool);

#endif
