#ifndef _ygString_h_
#define _ygString_h_

#include <string.h>
#include <limits.h>
#include <iostream>

class ygString
	{
	private:
	 char *data_;
	 int maxDataSize_;
	 int length_;
	 bool caseSensitive_;
	 void copy(const char*,int);
	 void doAppend(const char*,int);
	public:
	 static const int npos = INT_MAX;
	 ygString(void);
	 ygString(const char* s);
	 ygString(const ygString& s);
	 ygString& operator=(const char* s);
	 ygString& operator=(const ygString& s);
	 ~ygString(void);

	 ygString& append(char c);
	 ygString& append(const char* s);
	 ygString& append(const ygString& s);
	 inline ygString& operator+=(char c)
		{ return append(c); }
	 inline ygString& operator+=(const char* s)
		{ return append(s); }
	 inline ygString& operator+=(const ygString& s)
		{ return append(s); }
	 ygString& erase(int pos=0,int n=npos);
	 inline void clear(void)
		{ length_ = 0; if (data_) data_[0] = '\0'; }
	 ygString& insert(int pos,const ygString& s);

	 inline void setCaseSensitive(int val=1) { caseSensitive_ = val; }
	 inline int caseSensitive(void) const { return caseSensitive_; }
	 inline char * data(void) const { return data_; }
	 inline char * c_str(void) const { return data_; }
	 inline int length(void) const
		{ return length_; }
	 inline char operator[](int i) const
		{ if ((data_) && (i >= 0) && (i < length_)) return data_[i];
		  else return '\0'; }

	 int contains(const char* s) const;
	 int contains(const ygString& s) const;
	 inline int beginsWith(const char* s) const
		{ if (caseSensitive_) return (!strncmp(data_,s,strlen(s)));
		  else return (!strncasecmp(data_,s,strlen(s))); }
	 inline int beginsWith(const ygString& s) const
		{ if (caseSensitive_) return !strncmp(data_,s.data_,s.length_);
		  else return (!strncasecmp(data_,s.data_,s.length_)); }
	 int find(char c,int start=0) const;
	 int find_first_of(const char *c,int start=0) const;
	 int find_first_not_of(const char *c,int start=0) const;
	 int find_last_of(const char *c,int start=npos) const;
	 int find_last_not_of(const char *c,int start=npos) const;
	 ygString* nextToken(const char * separators, int * index) const;
	 ygString& assign(const ygString& from,int start,int n=npos);
	 ygString& replace(int pos, int n, const ygString& s);

	 friend inline int operator==(const ygString& a, const ygString& b)
	 	{ if (a.caseSensitive_) return (strcmp(a.data_,b.data_) == 0);
		  else return (strcasecmp(a.data_,b.data_) == 0); }
	 friend inline int operator==(const ygString& a, const char* b)
	 	{ if (a.caseSensitive_) return (strcmp(a.data_,b) == 0);
		  else return (strcasecmp(a.data_,b) == 0); }
	 friend inline int operator==(const char* a, const ygString& b)
	 	{ if (b.caseSensitive_) return (strcmp(a,b.data_) == 0);
		  else return (strcasecmp(a,b.data_) == 0); }

	 friend inline int operator<(const ygString& a, const ygString& b)
	 	{ if (a.caseSensitive_) return (strcmp(a.data_,b.data_) < 0);
		  else return (strcasecmp(a.data_,b.data_) < 0); }
	 friend inline int operator<(const ygString& a, const char* b)
	 	{ if (a.caseSensitive_) return (strcmp(a.data_,b) < 0);
		  else return (strcasecmp(a.data_,b) < 0); }
	 friend inline int operator<(const char* a, const ygString& b)
	 	{ if (b.caseSensitive_) return (strcmp(a,b.data_) < 0);
		  else return (strcasecmp(a,b.data_) < 0); }

	 friend inline int operator<=(const ygString& a, const ygString& b)
	 	{ if (a.caseSensitive_) return (strcmp(a.data_,b.data_) <= 0);
		  else return (strcasecmp(a.data_,b.data_) <= 0); }
	 friend inline int operator<=(const ygString& a, const char* b)
	 	{ if (a.caseSensitive_) return (strcmp(a.data_,b) <= 0);
		  else return (strcasecmp(a.data_,b) <= 0); }
	 friend inline int operator<=(const char* a, const ygString& b)
	 	{ if (b.caseSensitive_) return (strcmp(a,b.data_) <= 0);
		  else return (strcasecmp(a,b.data_) <= 0); }

	 friend inline int operator>(const ygString& a, const ygString& b)
	 	{ if (a.caseSensitive_) return (strcmp(a.data_,b.data_) > 0);
		  else return (strcasecmp(a.data_,b.data_) > 0); }
	 friend inline int operator>(const ygString& a, const char* b)
	 	{ if (a.caseSensitive_) return (strcmp(a.data_,b) > 0);
		  else return (strcasecmp(a.data_,b) > 0); }
	 friend inline int operator>(const char* a, const ygString& b)
	 	{ if (b.caseSensitive_) return (strcmp(a,b.data_) > 0);
		  else return (strcasecmp(a,b.data_) > 0); }

	 friend inline int operator>=(const ygString& a, const ygString& b)
	 	{ if (a.caseSensitive_) return (strcmp(a.data_,b.data_) >= 0);
		  else return (strcasecmp(a.data_,b.data_) >= 0); }
	 friend inline int operator>=(const ygString& a, const char* b)
	 	{ if (a.caseSensitive_) return (strcmp(a.data_,b) >= 0);
		  else return (strcasecmp(a.data_,b) >= 0); }
	 friend inline int operator>=(const char* a, const ygString& b)
	 	{ if (b.caseSensitive_) return (strcmp(a,b.data_) >= 0);
		  else return (strcasecmp(a,b.data_) >= 0); }

	 friend inline int operator!=(const ygString& a, const ygString& b)
	 	{ if (a.caseSensitive_) return (strcmp(a.data_,b.data_) != 0);
		  else return (strcasecmp(a.data_,b.data_) != 0); }
	 friend inline int operator!=(const ygString& a, const char* b)
	 	{ if (a.caseSensitive_) return (strcmp(a.data_,b) != 0);
		  else return (strcasecmp(a.data_,b) != 0); }
	 friend inline int operator!=(const char* a, const ygString& b)
	 	{ if (b.caseSensitive_) return (strcmp(a,b.data_) != 0);
		  else return (strcasecmp(a,b.data_) != 0); }

	 friend inline std::ostream& operator<< (std::ostream& s, const ygString& str)
                { if (str.data_) return s << str.data_;
		  else return s; }

	};


#endif
