// Revision: 11/01/01 Dave Pape

#include <malloc.h>
#include <stdio.h>
#include "ygString.h"


void ygString::copy(const char* s,int len)
	{
	length_ = len;
	if (maxDataSize_ < length_+1)
		{
		if (data_)
			free(data_);
		maxDataSize_ = length_ + 1;
		data_ = (char *) malloc(maxDataSize_);
		}
	strcpy(data_, s);
	}

void ygString::doAppend(const char* s,int len)
	{
	if (maxDataSize_ < length_+len+1)
		{
		maxDataSize_ = length_ + len + 64;
		data_ = (char *) realloc(data_, maxDataSize_);
		}
	strcpy(data_+length_, s);
	length_ += len;
	}


ygString::ygString(void)
	{
	maxDataSize_ = 24;
	data_ = (char*) malloc(maxDataSize_);
	data_[0] = '\0';
	caseSensitive_ = 0;
	length_ = 0;
	}

ygString::ygString(const char* s)
	{
	maxDataSize_ = 0;
	data_ = NULL;
	caseSensitive_ = 0;
	if (s)
		copy(s,strlen(s));
	}

ygString::ygString(const ygString& s)
	{
	maxDataSize_ = 0;
	data_ = NULL;
	caseSensitive_ = 0;
	if (s.data_)
		copy(s.data_,s.length_);
	}


ygString& ygString::operator=(const char* s)
	{
	if (s)
		copy(s,strlen(s));
	else if (data_)
		*data_ = '\0';
	return *this;
	}


ygString& ygString::operator=(const ygString& s)
	{
	if (s.data_)
		copy(s.data_,s.length_);
	else if (data_)
		*data_ = '\0';
	return *this;
	}


ygString::~ygString(void)
	{
	if (data_)
		free(data_);
	}


ygString& ygString::erase(int pos,int n)
	{
	if ((length_ == 0) || (pos >= length_))
		return *this;
	if (pos < 0)
		pos = 0;
	if (n >= length_ - pos)
		data_[pos] = '\0';
	else
		memmove(data_+pos, data_+pos+n, length_-pos-n+1);
	length_ = strlen(data_);
	return *this;
	}


ygString& ygString::insert(int pos,const ygString& s)
	{
	if (!s.data_)
		return *this;
	if (pos < 0)
		pos = 0;
	else if (pos > length_)
		pos = length_;
	if (maxDataSize_ < length_ + s.length_ + 1)
		{
		maxDataSize_ = length_ + s.length_ + 64;
		data_ = (char *) realloc(data_, maxDataSize_);
		}
	memmove(data_+pos+s.length_, data_+pos, length_+1-pos);
	memcpy(data_+pos, s.data_, s.length_);
	length_ += s.length_;
	return *this;
	}


ygString& ygString::append(const char* s)
	{
	if (s)
		doAppend(s,strlen(s));
	return *this;
	}

ygString& ygString::append(char c)
	{
	char s[2];
	s[0] = c;
	s[1] = '\0';
	doAppend(s,1);
	return *this;
	}


ygString& ygString::append(const ygString& s)
	{
	if (s.data_)
		doAppend(s.data_,s.length_);
	return *this;
	}


/* A case-insensitive version of strstr */
static int strContains(const char *s1, const char *s2)
	{
	int l1, l2;

	if (!s2)
		return 1;
	if (!s1)
		return 0;
	l2 = strlen(s2);
	if (!l2)
		return 1;
	l1 = strlen(s1);
	while (l1 >= l2)
		{
		l1--;
		if (!strncasecmp(s1,s2,l2))
			return 1;
		s1++;
		}
	return 0;
	}

int ygString::contains(const char* s) const
	{
	if (!s)
		return 1;
	if (!data_)
		return 0;
	if (caseSensitive_)
		return (strstr(data_,s) != NULL);
	else
		return strContains(data_,s);
	}

int ygString::contains(const ygString& s) const
	{
	if (!s.data_)
		return 1;
	if (!data_)
		return 0;
	if (caseSensitive_)
		return (strstr(data_,s.data_) != NULL);
	else
		return strContains(data_,s.data_);
	}


int ygString::find_last_of(const char *c,int start) const
	{
	int i;
	if (start > length_ - 1)
		start = length_ - 1;
	for (i=start; i >= 0 ; i--)
		{
		if (strchr(c,data_[i]))
			return i;
		}
	return npos;
	}


int ygString::find_last_not_of(const char *c,int start) const
	{
	int i;
	if (start > length_ - 1)
		start = length_ - 1;
	for (i=start; i >= 0 ; i--)
		{
		if (!strchr(c,data_[i]))
			return i;
		}
	return npos;
	}


int ygString::find(char c,int start) const
	{
	int i;
	if (start < 0)
		start = 0;
	for (i=start; i < length_; i++)
		{
		if (data_[i] == c)
			return i;
		}
	return npos;
	}


int ygString::find_first_of(const char *c,int start) const
	{
	int i;
	if (start < 0)
		start = 0;
	for (i=start; i < length_; i++)
		{
		if (strchr(c,data_[i]))
			return i;
		}
	return npos;
	}


int ygString::find_first_not_of(const char *c,int start) const
	{
	int i;
	if (start < 0)
		start = 0;
	for (i=start; i < length_; i++)
		{
		if (!strchr(c,data_[i]))
			return i;
		}
	return npos;
	}


ygString& ygString::assign(const ygString& from,int start,int n)
	{
	if (start < 0)
		start = 0;
	else if (start >= from.length_)
		start = from.length_;
	if (n < 0)
		n = 0;
	if ((n != npos) && (n <= from.length_ - start))
		length_ = n;
	else
		length_ = from.length_ - start;
	if (maxDataSize_ < (length_ + 1))
		{
		if (data_)
			free(data_);
		maxDataSize_ = length_ + 1;
		data_ = (char *) malloc(maxDataSize_);
		}
	strncpy(data_, from.data_+start, length_);
	data_[length_] = '\0';
	return *this;
	}


ygString& ygString::replace(int pos, int n, const ygString& s)
	{
	erase(pos,n);
	insert(pos,s);
	return *this;
	}


ygString* ygString::nextToken(const char * separators, int * index) const
	{
	int endindex;
	ygString *token;
	*index = find_first_not_of(separators,*index);
	if (*index == npos)
		return NULL;
	token = new ygString;
	endindex = find_first_of(separators,*index);
	if (endindex < npos)
		token->assign(*this,*index,endindex-*index);
	else
		token->assign(*this,*index);
	*index = endindex;
	return token;
	}
