// Revision: 11/01/01 Dave Pape

#include <math.h>
#include "ygSphere.h"

ygSphere::ygSphere(void)
	{
	pfSphere::makeEmpty();
	}

ygSphere::ygSphere(const pfSphere & sph)
	{
	pfSphere::center = sph.center;
	pfSphere::radius = sph.radius;
	}


ygSphere::~ygSphere(void)
	{
	}


ygSphere& ygSphere::operator=(const pfSphere & sph)
	{
	pfSphere::center = sph.center;
	pfSphere::radius = sph.radius;
	return *this;
	}


float ygSphere::distance(const pfVec3 & v) const
	{
	float centerDistSq = v.sqrDistance(center);
	if (centerDistSq <= radius * radius)
		return 0.0f;
	return sqrtf(centerDistSq) - radius;
	}


float ygSphere::sqrDistance(const pfVec3 & v) const
	{
	float dist = distance(v);
	return dist * dist;
	}


int ygSphere::contains(const pfVec3 &v) const
	{
	return pfSphere::contains(v);
	}

int ygSphere::isect(const pfSeg *s,float *d0,float *d1) const
	{
	return pfSphere::isect(s,d0,d1);
	}

void ygSphere::makeEmpty(void)
	{
	pfSphere::makeEmpty();
	}

void ygSphere::extendBy(const pfVec3 & v)
	{
	pfSphere::extendBy(v);
	}

void ygSphere::extendBy(const pfBox * box)
	{
	pfVec3 corner;
	pfSphere::extendBy(box->min);
	corner[0] = box->min[0];  corner[1] = box->min[1];  corner[2] = box->max[2];
	pfSphere::extendBy(corner);
	corner[0] = box->min[0];  corner[1] = box->max[1];  corner[2] = box->min[2];
	pfSphere::extendBy(corner);
	corner[0] = box->min[0];  corner[1] = box->max[1];  corner[2] = box->max[2];
	pfSphere::extendBy(corner);
	corner[0] = box->max[0];  corner[1] = box->min[1];  corner[2] = box->min[2];
	pfSphere::extendBy(corner);
	corner[0] = box->max[0];  corner[1] = box->min[1];  corner[2] = box->max[2];
	pfSphere::extendBy(corner);
	corner[0] = box->max[0];  corner[1] = box->max[1];  corner[2] = box->min[2];
	pfSphere::extendBy(corner);
	pfSphere::extendBy(box->max);
	}

void ygSphere::extendBy(const pfSphere * sph)
	{
	pfSphere::extendBy(sph);
	}

void ygSphere::extendBy(const pfCylinder * cyl)
	{
	pfSphere::extendBy(cyl);
	}

void ygSphere::around(const pfVec3 * vert,int nvert)
	{
	pfSphere::around(vert,nvert);
	}

void ygSphere::around(const pfBox ** boxes,int nboxes)
	{
	pfSphere::around(boxes,nboxes);
	}

void ygSphere::around(const pfSphere ** sph,int nsph)
	{
	pfSphere::around(sph,nsph);
	}

void ygSphere::around(const pfCylinder ** cyl,int ncyl)
	{
	pfSphere::around(cyl,ncyl);
	}


float ygSphere::size(void) const
	{
	return pfSphere::radius;
	}


int ygSphere::volumeType(void) const
	{
	return YGVOL_SPHERE;
	}
