#ifndef _ygSpace_h_
#define _ygSpace_h_

#include "ygVolume.h"
#include "ygNode.h"


class ygSpace : public ygNode
	{
	public:
	 ygSpace(const char*,bool master=true);
	 virtual ~ygSpace(void);
	 virtual void reset(void);
	 virtual void message(const ygMessage&);
		 void setVolume(ygVolume * vol);
	 inline const ygVolume* volume(void) const { return volume_; }
	 inline bool contains(pfVec3 p) const
			{ if (volume_) return volume_->contains(p); else return true; }
	protected:
	 virtual void acceptNetKey(const ygString&);
	private:
	 ygVolume * volume_;
	 struct _ygSpacePrivateData * p_;
	 void makeDebugOutline(void);
	};

extern "C" ygNode* construct_ygSpace(const char*,bool);


#endif
