#ifndef _ygSoundServer_h_
#define _ygSoundServer_h_

#include "ygSpace.h"


class ygSoundServer : public ygSpace
	{
	public:
	 ygSoundServer(const char*,bool master=true);
	 virtual ~ygSoundServer(void);
	 virtual void reset(void);
	 virtual void message(const ygMessage&);
	 virtual void app(void);
	 virtual void play(void);
	 virtual void stop(bool sendStopCommand=true);
	 virtual void setAmplitude(float);
	 virtual void setFalloffDistance(float);
	 virtual bool isPlaying(void);
	 virtual float computeAmplitude(void);
	 static void initServer(void);
	 static void updateServer(void);
	 static void closeServer(void);
	 static void addSound(ygSoundServer*);
	 static void removeSound(ygSoundServer*);
	 static class bergenServer* server(void);
	 void heartbeat(void);
	protected:
	 virtual void acceptNetKey(const ygString& key);
	private:
	 struct _ygSoundServerPrivateData * p_;
	 static struct _ygSoundServerGlobalData * global_;
	};

extern "C" ygNode* construct_ygSoundServer(const char*,bool);

#endif
