#ifndef _ygSimpleTransform_h_
#define _ygSimpleTransform_h_

#include <Performer/pr/pfLinMath.h>
#include "ygNode.h"


class ygSimpleTransform : public ygNode
	{
	public:
	 ygSimpleTransform(const char*,bool master=true);
	 virtual ~ygSimpleTransform(void);
	 virtual void reset(void);
	 virtual void message(const ygMessage&);
	 virtual void app(void);
		 void getMatrix(pfMatrix&) const;
		 void setMatrix(pfMatrix&);
		 void setPosition(float x,float y,float z);
		 void setOrientation(float x,float y,float z);
	 inline	 void setPosition(pfVec3 v) { setPosition(v[0],v[1],v[2]); }
	 inline	 void setOrientation(pfVec3 v) {setOrientation(v[0],v[1],v[2]);}
	protected:
	 virtual void acceptNetKey(const ygString&);
	private:
	 struct _ygSimpleTransformPrivateData *p_;
		 void setPosition(const ygMessage&);
		 void setOrientation(const ygMessage&);
	};


extern "C" ygNode* construct_ygSimpleTransform(const char*,bool);

#endif
