// Description: selects one child node for node processing and Performer traversal
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> this node can also be created with the alias: selector
//<li> this node uses a Performer pfSwitch
//<li> if the number or named child selected is not found the switch is turned off
//</ul>
//
// Category: Selection
// Author: Dave Pape
// Revision: 03/14/04 Alex Hill - fixed initialization bug 
//           11/01/01
//
#include <Performer/pf/pfSwitch.h>
#include "ygNetKeys.h"
#include "ygSelector.h"

using namespace std;


extern "C" ygNode* construct_ygSelector(const char* name,bool master) { return new ygSelector(name,master); }

struct _ygSelectorPrivateData
	{
	pfSwitch * sw;
	int selected, prevSelected;
	bool debugSelected;
	};


ygSelector::ygSelector(const char* name,bool master) : ygNode(name,master,false)
	{
	setClassName("ygSelector",true);
	p_ = new struct _ygSelectorPrivateData;
	//create a pfSwitch for selection
	p_->sw = new pfSwitch;
	setPfNode(p_->sw);
	//print out the number of the selected child
	debugFlag("selected",&p_->debugSelected);
	addNetKey("sel",&p_->selected,YG_NET_INT);
	reset();
	}


ygSelector::~ygSelector(void)
	{
	delete p_;
	}


void ygSelector::reset(void)
	{
	p_->prevSelected = PFSWITCH_OFF - 1;
	//if net master then select child 0
	if (isNetMaster())
		select(0);
	ygNode::reset();
	}


void ygSelector::app(void)
	{
	//if selection has changed
	if (p_->selected != p_->prevSelected)
		{
		int newVal;
		if ((p_->selected >= 0) && (p_->selected < numChildren()))
			newVal = p_->selected;
		else
			newVal = PFSWITCH_OFF;
		//set switch to selection
		p_->sw->setVal(newVal);
		p_->prevSelected = newVal;
		p_->selected = newVal;
		netKeyChanged("sel");
		if (p_->debugSelected)
			cout << "ygSelector " << name() << ": new value is "
				<< newVal << endl;
		}
	ygNode::app();
	}


void ygSelector::appTraverse(void)
	{
	//start timing
	timingBegin();
	//execute app method
	app();
	ygNode *sel = child(p_->selected);
	//call appTraverse recursively on selected child
	if (sel)
		sel->appTraverse();
	//end timing
	timingEnd();
	}


/*****  Selector functions *****/

void ygSelector::select(const ygString& childname)
	{
	for (int i=0; i < numChildren(); i++)
		if (childname == child(i)->name())
			{
			select(i);
			return;
			}
	select(-1);
	}


void ygSelector::select(int num)
	{
	p_->selected = num;
	}


ygNode* ygSelector::selected(void) const
	{
	return child(p_->selected);
	}


int ygSelector::selectedNum(void) const
	{
	return p_->selected;
	}


/***** Message functions *****/

void ygSelector::message(const ygMessage& msg)
	{
	//select the named child node
	if (msg == "select")
		{
		if (msg.args.size() == 1)
			select(msg.args[0]);
		else
			msg.error(name(),"(wrong number of arguments)");
		}
	//select the child node by number starting with zero
	else if (msg == "selectnum")
		{
		if (msg.args.size() == 1)
			select(msg.intArg(0));
		else
			msg.error(name(),"(wrong number of arguments)");
		}
	else
		ygNode::message(msg);
	}


/***** Net functions *****/

void ygSelector::acceptNetKey(const ygString& key)
	{
	if (key == "sel")
		;
	else
		ygNode::acceptNetKey(key);
	}
