// Revision: 11/01/01 Dave Pape

#include "ygPointVolume.h"

ygPointVolume::ygPointVolume(void)
	{
	vec[0] = vec[1] = vec[2] = 0.0f;
	}

ygPointVolume::ygPointVolume(const pfVec3 & v)
	{
	vec[0] = v[0];
	vec[1] = v[1];
	vec[2] = v[2];
	}


ygPointVolume::~ygPointVolume(void)
	{
	}


ygPointVolume& ygPointVolume::operator=(const pfVec3& v)
	{
	vec[0] = v[0];
	vec[1] = v[1];
	vec[2] = v[2];
	return *this;
	}


float ygPointVolume::sqrDistance(const pfVec3 & v) const
	{
	return pfVec3::sqrDistance(v);
	}


int ygPointVolume::contains(const pfVec3 &v) const
	{
	if (equal(v))
		return PFIS_MAYBE|PFIS_TRUE|PFIS_ALL_IN;
	else
		return PFIS_FALSE;
	}

int ygPointVolume::isect(const pfSeg *s,float *d0,float *d1) const
	{
	pfVec3 dirToPointVolume;
	float distToPointVolume;
	dirToPointVolume = *this - s->pos;
	distToPointVolume = s->dir.dot(dirToPointVolume);
	if ((distToPointVolume >= 0.0f) && (distToPointVolume <= s->length))
		{
		if (d0)
			*d0 = distToPointVolume;
		if (d1)
			*d1 = distToPointVolume;
		if (s->length == 0.0f)
			return PFIS_MAYBE|PFIS_TRUE|PFIS_START_IN|PFIS_END_IN|PFIS_ALL_IN;
		else if (distToPointVolume == 0.0f)
			return PFIS_MAYBE|PFIS_TRUE|PFIS_START_IN;
		else if (distToPointVolume == s->length)
			return PFIS_MAYBE|PFIS_TRUE|PFIS_END_IN;
		else
			return PFIS_MAYBE|PFIS_TRUE;
		}
	else
		return PFIS_FALSE;
	}

void ygPointVolume::makeEmpty(void)
	{
	vec[0] = vec[1] = vec[2] = 0.0f;
	}

void ygPointVolume::extendBy(const pfVec3 & v)
	{
	vec[0] = v[0];
	vec[1] = v[1];
	vec[2] = v[2];
	}

void ygPointVolume::extendBy(const pfBox * box)
	{
	pfVec3 center;
	center = (box->min + box->max) / 2;
	vec[0] = center[0];
	vec[1] = center[1];
	vec[2] = center[2];
	}

void ygPointVolume::extendBy(const pfSphere * sph)
	{
	vec[0] = sph->center[0];
	vec[1] = sph->center[1];
	vec[2] = sph->center[2];
	}

void ygPointVolume::extendBy(const pfCylinder * cyl)
	{
	vec[0] = cyl->center[0];
	vec[1] = cyl->center[1];
	vec[2] = cyl->center[2];
	}

void ygPointVolume::around(const pfVec3 * vert,int nvert)
	{
	if (nvert > 0)
		extendBy(vert[0]);
	}

void ygPointVolume::around(const pfBox ** boxes,int nboxes)
	{
	if (nboxes > 0)
		extendBy(boxes[0]);
	}

void ygPointVolume::around(const pfSphere ** sph,int nsph)
	{
	if (nsph > 0)
		extendBy(sph[0]);
	}

void ygPointVolume::around(const pfCylinder ** cyl,int ncyl)
	{
	if (ncyl > 0)
		extendBy(cyl[0]);
	}


float ygPointVolume::size(void) const
	{
	return 0;
	}


int ygPointVolume::volumeType(void) const
	{
	return YGVOL_POINT;
	}
