// Revision: 11/01/01 Dave Pape

#include <stdio.h>
#include <iostream>
#include <stack>
#include "ygTokenStream.h"
#include "ygNodeDB.h"
#include "ygNode.h"
#include "ygParser.h"

using namespace std;


ygParser::ygParser(void)
	{
	}


void ygParser::parseFile(const ygString& file,ygNode *root)
	{
	ygTokenStream *input;
	ygString token;
	stack<ygNode*> parentStack;
	ygNode *parent=root, *lastNode=NULL;
	input = new ygTokenStream(file);
	while (input->next(token))
		{
		if (token == "{")
			{
			parentStack.push(parent);
			if (!lastNode)
				{
				ygString name;
				ygNode::createDummyName(name);
				lastNode = ygNodeDB::create("group",name,
								input);
				parent->addChild(lastNode);
				}
			parent = lastNode;
			lastNode = NULL;
			}
		else if (token == "}")
			{
			if (!parentStack.empty())
				{
				parent = parentStack.top();
				parentStack.pop();
				}
			}
		else if (token[0] == '(')
			{
			cerr << "ERROR: parsing " << input->filename()
				<< ", line " << input->linenumber()
				<< ": there's no node for this option list:"
				<< endl << "\t" << token << endl;
			}
		else
			{
			lastNode = parseNode(token,input);
			if (lastNode)
				parent->addChild(lastNode);
			}
		}
	delete input;
	}


ygNode * ygParser::parseNode(const ygString& nodeType,ygTokenStream *input)
	{
	bool gotToken=true;
	ygString token, name;
	ygNode *node;
	gotToken = input->next(token);
	if ((gotToken) && (token[0] != '(') && (token[0] != '{') &&
	    (token[0] != '}'))
		{
		name = token;
		gotToken = input->next(token);
		}
	else
		ygNode::createDummyName(name);
	node = ygNodeDB::create(nodeType,name,input);
	if (gotToken)
		{
		if (token[0] == '(')
			{
			if (node)
				parseInitMessages(node,token);
			}
		else
			input->pushback(token);
		}
	return node;
	}


void ygParser::parseInitMessages(ygNode * node,ygString& msgList)
	{
	ygString msg;
	int index=1;
	if (msgList[msgList.length()-1] != ')')
			msgList += ')';
	while (1)
		{
		msg.clear();
		while ((msgList[index] == ' ') || (msgList[index] == '\t'))
			index++;
		if (msgList[index] != ')')
			{
			int parenDepth=0, quoting=0;
			while ((parenDepth) || (quoting) ||
				((msgList[index] != ',') &&
				 (msgList[index] != ')')))
				{
				if (msgList[index] == '\\')
					{
					if (quoting)
						msg += msgList[index];
					index++;
					}
				else if (msgList[index] == '"')
					quoting = !quoting;
				else if ((!quoting) && (msgList[index] == '('))
					parenDepth++;
				else if ((!quoting) && (msgList[index] == ')'))
					parenDepth--;
				msg += msgList[index];
				index++;
				}
			node->addInitMessage(msg);
			if (msgList[index] == ',')
				index++;
			}
		else
			break;
		}
	}
