// Revision: 01/20/03 Alex Hill

#include <Performer/pr/pfTexture.h>
#include <map>
#include "ygString.h"
#include "ygPFTextureCache.h"

using namespace std;


struct _ygPFTextureCachePrivateData
	{
	pfTexture* nextTexture;
	map<ygString,pfTexture*> textures;
	};


struct _ygPFTextureCachePrivateData* ygPFTextureCache::p_ = NULL;


pfTexture * ygPFTextureCache::textureReference(const ygString& file)
	{
	pfTexture* texture;
	if (!p_)
		{
		p_ = new struct _ygPFTextureCachePrivateData;
		p_->nextTexture = new pfTexture;
		}
	texture = p_->textures[file];
	if (!texture)
		{
		if (p_->nextTexture->loadFile(file.c_str()))
			{
			texture = p_->nextTexture;
			p_->textures[file] = p_->nextTexture;
			p_->nextTexture = new pfTexture;
			}
		}
	return texture;
	}
