// Revision: 11/01/01 Dave Pape

#include <Performer/pfdu.h>
#include <Performer/pf/pfNode.h>
#include <map>
#include "ygString.h"
#include "ygPFObjectCache.h"

using namespace std;


struct _ygPFObjectCachePrivateData
	{
	map<ygString,pfNode*> objects;
	};


struct _ygPFObjectCachePrivateData* ygPFObjectCache::p_ = NULL;


pfNode * ygPFObjectCache::objectReference(const ygString& file)
	{
	pfNode *node;
	if (!p_)
		p_ = new struct _ygPFObjectCachePrivateData;
	node = p_->objects[file];
	if (!node)
		{
		node = pfdLoadFile(file.c_str());
		p_->objects[file] = node;
		}
	return node;
	}


pfNode * ygPFObjectCache::objectClone(const ygString& file)
	{
	pfNode * node = objectReference(file);
	if (node)
		return node->clone(0);
	else
		return NULL;
	}
