#ifndef _ygObject_h_
#define _ygObject_h_

#include "ygString.h"
#include "ygMessage.h"
#include "ygTransform.h"


class ygObject : public ygTransform
	{
	public:
	 ygObject(const char*,bool master=true);
	 virtual ~ygObject(void);
	 virtual void reset(void);
	 virtual void message(const ygMessage&);
		 void loadFile(const ygString&);
		 void setWall(bool val=true);
		 void setFloor(bool val=true);
		 void setDraw(bool val=true);
		 void showLocal(bool val=true);
		 const ygString& filename(void) const;
	protected:
	 virtual void acceptNetKey(const ygString&);
	private:
	 struct _ygObjectPrivateData * p_;
	};


extern "C" ygNode* construct_ygObject(const char*,bool);

#endif
