#ifndef _ygNodeDB_h_
#define _ygNodeDB_h_

#include <vector>
#include "ygString.h"
class ygNode;
class ygTokenStream;


class ygNodeDB
	{
	public:
	 static void init(void);
	 static ygNode* find(const ygString& name, bool connect=true);
	 static ygNode* create(const ygString& ntype, const ygString& name,
					ygTokenStream *ts=NULL);
	 static ygNode* createProxy(const ygString&, const ygString&);
	 static const std::vector<ygNode*>& nodesOfType(const ygString& nodeType);
	private:
	 static struct _ygNodeDBPrivateData * p_;
	};


#endif
