// Revision: 11/01/01 Dave Pape

#include <map>
#include "ygUtil.h"
#include "ygTokenStream.h"
#include "ygNode.h"
#include "ygTransform.h"
#include "ygSimpleTransform.h"
#include "ygObject.h"
#include "ygTexture.h"
#include "ygLight.h"
#include "ygSwitch.h"
#include "ygSelector.h"
#include "ygUser.h"
#include "ygWand.h"
#include "ygSound.h"
#include "ygSpace.h"
#include "ygEnvironment.h"
#include "ygCAVEHead.h"
#include "ygCAVENavigator.h"
#include "ygCAVETracker.h"
#include "ygCAVEWand.h"
#include "ygDSOLoader.h"
#include "ygNet.h"
#include "ygNodeDB.h"

using namespace std;


struct _ygNodeDBPrivateData
	{
	map<ygString,ygNode*> nodes;
	map<ygString, vector<ygNode*> > nodesByType;
	};

struct _ygNodeDBPrivateData* ygNodeDB::p_ = NULL;



void ygNodeDB::init(void)
	{
	ygNet::init();
	if (!p_)
		p_ = new struct _ygNodeDBPrivateData;
	}


ygNode* ygNodeDB::find(const ygString& name,bool connect)
	{
	ygNode* node = p_->nodes[name];
	if ((!node) && (connect))
		node = ygNet::connectNewNode(name);
	return node;
	}


ygNode * ygNodeDB::create(const ygString& nodeType,const ygString& nodeName,
			  ygTokenStream *tStream)
	{
	if (p_->nodes[nodeName] != NULL)
		cerr << "ERROR: ygNodeDB::create: a node named '" << nodeName
			<< "' already exists\n";
	ygNode *node = NULL;
	ygNodeConstructorPtr constructPtr = ygDSOLoader::getNodeConstructor(nodeType);
	if (constructPtr)
		node = (*constructPtr)(nodeName.c_str(),true);
	if (!node)
		{
// NOTE: This may cause problems on SGIs when using STL strings!!
		cerr << "ERROR: ygNodeDB::create: unknown node type '"
			<< nodeType << "'";
		if (tStream)
			cerr << " (file " << tStream->filename() << ", line "
				<< tStream->linenumber() << ")";
		cerr << " - replacing with Group" << endl;
		node = new ygNode(nodeName.c_str());
		}
	if (node)
		{
		p_->nodes[nodeName] = node;
		p_->nodesByType[nodeType].push_back(node);
		ygNet::storeNode(node);
		}
	return node;
	}


ygNode * ygNodeDB::createProxy(const ygString& proxyType,const ygString& nodeName)
	{
	ygNode *node = NULL;
	ygNodeConstructorPtr constructPtr = ygDSOLoader::getNodeConstructor(proxyType);
	if (constructPtr)
		node = (*constructPtr)(nodeName.c_str(),false);
	if (!node)
		{
		cerr << "ERROR: ygNodeDB::createProxy: unknown node type '"
			<< proxyType << "' - replacing with Group" << endl;
		node = new ygNode(nodeName.c_str(),false);
		}
	if (node)
		{
		p_->nodes[nodeName] = node;
		p_->nodesByType[proxyType].push_back(node);
		node->requestNetKeys();
		}
	return node;
	}


const vector<ygNode*>& ygNodeDB::nodesOfType(const ygString& nodeType)
	{
	return p_->nodesByType[nodeType];
	}
