#ifndef _ygNode_h_
#define _ygNode_h_

#include "ygString.h"
#include "ygMessage.h"
class pfGroup;

class ygNode
	{
	public:
	 ygNode(const char* name,bool master=true,bool createPfNode=true);
	 virtual ~ygNode(void);
	 virtual void reset(void);
	 virtual void message(const ygMessage&);
	 virtual void app(void);
	 virtual void appTraverse(void);
	 	 void resetTree(void);
		 const ygString& name(void) const;
 		 ygNode * parent(void) const;
 		 int numChildren(void) const;
	 	 ygNode * child(int index) const;
 		 void addChild(ygNode *child,bool doLocal=false);
 		 void removeChild(ygNode *child,bool doLocal=false);
	 	 void when(const ygString& event,const ygString& message);
		 void eventOccurred(const ygString& event,const ygString& args="");
		 pfGroup * pfnode(void) const;
		 pfVec3 origin(const ygNode *other=NULL) const;
		 void getTransform(pfMatrix& mat) const;
		 void getParentTransform(pfMatrix& mat) const;
		 void addInitMessage(const ygString&);
		 void sendNetMessage(const ygString&);
		 void sendNetMessage(const ygMessage&);
		 void receiveNetKey(const ygString& key,void *data);
	 virtual void requestNetKeys(void) const;
		 void netKeyChanged(const ygString& keyname,bool force=false);
		 bool isNetMaster(void) const;
		 bool pfChanged(void);
		 void setPFChanged(void);
		 const ygString& netClassName(void) const;
		 const ygString& className(void) const;
		 const ygString& classDerivation(void) const;
		 bool isOfClass(const ygString&) const;
		 void printTimingStats(int indent=0);
	 static void createDummyName(ygString& name);
	protected:
		 void setClassName(const ygString&,bool net=false);
		 void debugFlag(const ygString&,bool *);
		 void addNetKey(const ygString& keyname, void* data, int datatype);
		 void setPfNode(pfGroup *);
	 virtual void acceptNetKey(const ygString& key);
		 void timingBegin(void);
		 void timingAppDone(void);
		 void timingEnd(void);
		 void dontBroadcastNetKey(const ygString& keyname);
		 void unreliableKey(const ygString&);
		 void reliableKey(const ygString&);
	private:
		 void sendInitMessages(void);
		 void updateChildrenKey(void);
		 void removeAllChildren(void);
		 void storeChildrenKey(void);
	 struct _ygNodePrivateData * p_;
	};

extern "C" ygNode* construct_ygNode(const char*,bool);

#endif
