#ifndef _ygNetKeys_h_
#define _ygNetKeys_h_

#include "ygString.h"

enum
	{
	YG_NET_STRING,
	YG_NET_INT,
	YG_NET_FLOAT,
	YG_NET_BOOL,
	YG_NET_VEC2,
	YG_NET_VEC3,
	YG_NET_VEC4,
	YG_NET_MATRIX,
	YG_NET_COORD,
	};


class ygNetKeys
	{
	public:
	 ygNetKeys(void);
	 ~ygNetKeys(void);
		 void addKey(const ygString&,void *,int);
		 void setNodeName(const ygString& name);
		 void storeKey(const ygString& keyname);
		 void reliableKey(const ygString& keyname);
		 void unreliableKey(const ygString& keyname);
		 void requestAllKeys(void);
		 bool receiveKey(const ygString& key,void *data);
		 void dontBroadcast(const ygString&);
	private:
	 struct _ygNetKeysPrivateData * p_;
	 void storeStringKey(const ygString& keyname,struct _ygNetKeysData *d);
	 void storeIntKey(const ygString& keyname,struct _ygNetKeysData *d);
	 void storeFloatKey(const ygString& keyname,struct _ygNetKeysData *d);
	 void storeBoolKey(const ygString& keyname,struct _ygNetKeysData *d);
	 void storeVec2Key(const ygString& keyname,struct _ygNetKeysData *d);
	 void storeVec3Key(const ygString& keyname,struct _ygNetKeysData *d);
	 void storeVec4Key(const ygString& keyname,struct _ygNetKeysData *d);
	 void storeMatrixKey(const ygString& keyname,struct _ygNetKeysData *d);
	 void storeCoordKey(const ygString& keyname,struct _ygNetKeysData *d);
	 void receiveStringKey(const ygString& keyname,struct _ygNetKeysData *d,void*);
	 void receiveIntKey(const ygString& keyname,struct _ygNetKeysData *d,void*);
	 void receiveFloatKey(const ygString& keyname,struct _ygNetKeysData *d,void*);
	 void receiveBoolKey(const ygString& keyname,struct _ygNetKeysData *d,void*);
	 void receiveVec2Key(const ygString& keyname,struct _ygNetKeysData *d,void*);
	 void receiveVec3Key(const ygString& keyname,struct _ygNetKeysData *d,void*);
	 void receiveVec4Key(const ygString& keyname,struct _ygNetKeysData *d,void*);
	 void receiveMatrixKey(const ygString& keyname,struct _ygNetKeysData *d,void*);
	 void receiveCoordKey(const ygString& keyname,struct _ygNetKeysData *d,void*);
	};

#endif
