#ifndef _ygNetClient_h_
#define _ygNetClient_h_

#include "ygString.h"


enum {
	YG_NET_PUT_KEY,
	YG_NET_FETCH_KEY,
	YG_NET_PING,
	YG_NET_REQUEST_ALL,
	YG_NET_DOWNLOAD_DONE,
	YG_NET_REFRESH_KEY
	};

#define YG_NET_MAX_BUFFER_SIZE 65536


typedef void (*ygNetClientCallback)(char*, char*, void *);

class ygNetClient
	{
	public:
	 ygNetClient(void);
	 void init(const ygString& server,int port);
	 void trigger(ygNetClientCallback cb, void *data);
	 void process(void);
	 void * get(const ygString& path,const ygString& key,size_t *size);
	 void put(const ygString& path, const ygString& key, void *data, size_t size);
	 void putUnreliably(const ygString& path, const ygString& key, void *data, size_t size);
	 void fetch(const ygString& path,const ygString& key);
	 void reset(void);
	 void showStats(void);
	 void flushWrites(void);
	private:
	 struct _ygNetClientPrivateData * p_;
	 void flushTCPWrite(void);
	 void flushUDPWrite(void);
	 bool receivePacket(void);
	 bool processKeyData(ygString& path,ygString& key,int packetType=YG_NET_PUT_KEY);
	 class ygNetClientKey * getKeyStruct(const ygString& path, const ygString& key,bool owned);
	 void saveKeyData(const ygString& path, const ygString& key, void *data, size_t size);
	 void sendKeyDataTCP(const ygString& path, const ygString& key, void *data, size_t size,int sendType=YG_NET_PUT_KEY);
	 void sendKeyDataUDP(const ygString& path, const ygString& key, void *data, size_t size,int sendType=YG_NET_PUT_KEY);
	 bool receiveTCPPacket(void);
	 bool receiveUDPPacket(void);
	 void downloadViaTCP(const ygString& server,int port);
	 void uploadViaTCP(void);
	};


#endif
