#ifndef _ygNet_h_
#define _ygNet_h_

#include "ygString.h"
class ygNode;


class ygNet
	{
	public:
	 static void init(void);
	 static void reset(void);
	 static void halt(void);
	 static ygNode* connectNewNode(const ygString& name);
	 static void storeNode(ygNode* node);
	 static void requestKey(const ygString&, const char*);
	 static char* getKey(const char*,const char*,int*,float timeout=3);
	 static void storeKey(const ygString&, const char*,const ygString&, bool reliable=false);
	 static void storeKey(const ygString&, const char*,const void*,size_t, bool reliable=false);
	 static void process(void);
	 static void showStats(void);
	 static void midframeProcess(void);
	private:
	 static void receiveData(char* path, char* key, void*);
	 static void* netProcess(void*);
	 static void netProcessRequests(void);
	 static void pushNetRequest(struct _ygNetRequest * req);
	 static struct _ygNetRequest * popNetRequest(void);
	 static struct _ygNetPrivateData * p_;
	};


#endif
