// Description: creates a navigator with navigation data for the user
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> sets the navigator of the user above it for use in navigation
//<li> this node serves no purpose other than as a base class for <a href="ygCAVENavigator.html">ygCAVENavigator</a>
//</ul>
//
// Category: User
// Author: Dave Pape
// Revision: 11/01/01
//
#include "ygUser.h"
#include "ygNavigator.h"


ygNavigator::ygNavigator(const char* name,bool master) : ygNode(name,master)
	{
	user_ = NULL;
	}


void ygNavigator::reset(void)
	{
	//find the user ancestor of this node
	user_ = ygUser::findUserAncestor(this);
	//if found set navigator of that user to this node
	if (user_)
		user_->setNavigator(this);
	navData_.reset();
	ygNode::reset();
	}


void ygNavigator::app(void)
	{
	//update navigation data
	navData_.update(user_);
	ygNode::app();
	}
