#ifndef _ygNavData_h_
#define _ygNavData_h_

#include <Performer/pr/pfLinMath.h>
class ygUser;

class ygNavData
	{
	public:
	 ygNavData(void);
		 void reset(void);
		 void update(ygUser *) const;
	 inline	 void setPosition(float x,float y,float z)
				{ position_.set(x,y,z); }
	 inline	 void setPosition(const pfVec3& v)
				{ position_ = v; }
	 inline	 void setOrientation(float x, float y, float z)
				{ orientation_.set(x,y,z); }
	 inline	 void setOrientation(const pfVec3& v)
				{ orientation_ = v; }
	 inline	 void setHeading(float h)
				{ orientation_[PF_Z] = h; }
	 inline	 void setSize(float s)
				{ size_[PF_X] = size_[PF_Y] = size_[PF_Z] = s; }
	 inline	 void setSize(float sx,float sy,float sz)
				{ size_.set(sx,sy,sz); }
	 inline	 void setSize(const pfVec3& s)
				{ size_ = s; }
	 inline	 const pfVec3& position(void) const
				{ return position_; }
	 inline	 const pfVec3& orientation(void) const
				{ return orientation_; }
	 inline	 float heading(void) const
				{ return orientation_[PF_Z]; }
	 inline	 const pfVec3& size(void) const
				{ return size_; }
	 inline	 float zSize(void) const
				{ return size_[PF_Z]; }
	private:
	 pfVec3 position_;
	 pfVec3 orientation_;
	 pfVec3 size_;
	};

#endif
