// Revision: 11/01/01 Dave Pape

#include <pfcave.h>
#include "ygUser.h"
#include "ygNavData.h"


ygNavData::ygNavData(void)
	{
	CAVESetOption(CAVE_PROJ_INCLUDENAVIGATION, 1);
	reset();
	}


void ygNavData::reset(void)
	{
	position_.set(0,0,0);
	orientation_.set(0,0,0);
	}


void ygNavData::update(ygUser *user) const
	{
	CAVENavLock();
	CAVENavLoadIdentity();
	CAVENavTranslate(position_[0],position_[1],position_[2]);
	CAVENavRot(orientation_[PF_Z],'z');
	CAVENavRot(orientation_[PF_X],'x');
	CAVENavRot(orientation_[PF_Y],'y');
	CAVENavUnlock();
	user->setPosition(position_);
	user->setOrientation(orientation_);
	}
