// Revision: 11/01/01 Dave Pape

#include <stdlib.h>
#include <ulocks.h>
#include "ygMutex.h"


struct _ygMutexPrivateData
	{
	ulock_t lock;
	};

static usptr_t * ygMutexArena = 0;


ygMutex::ygMutex(void)
	{
	if (!ygMutexArena)
		{
		usconfig(CONF_LOCKTYPE,US_NODEBUG);
		if ((ygMutexArena = usinit("/dev/zero")) == 0)
			{
			fprintf(stderr,"ERROR: ygMutex failed to create arena\n");
			perror("usinit");
			exit(1);
			}
		}
	p_ = new struct _ygMutexPrivateData;
	p_->lock = usnewlock(ygMutexArena);
	}


void ygMutex::lock(void)
	{
	ussetlock(p_->lock);
	}


void ygMutex::unlock(void)
	{
	usunsetlock(p_->lock);
	}
