#ifndef _ygMessage_h_
#define _ygMessage_h_

#include <stdlib.h>
#include <iostream>
#include <vector>
#include <Performer/pr/pfLinMath.h>
#include "ygString.h"
class ygNode;
class ygEvent;


class ygMessage
	{
	public:
	 ygString message;
	 std::vector<ygString> args;
	 ygNode * node;
	 ygString nodeName;
	 float delay;
	
	 friend inline bool operator==(const ygMessage& a,const ygString& b)
		{ return a.message == b; }
	 friend inline bool operator==(const ygString& a,const ygMessage& b)
		{ return a == b.message; }
	 inline const ygString& stringArg(int i) const
		{ return args[i]; }
	 inline float floatArg(int i) const
		{
		if (args.size() > i)
			return atof(args[i].c_str());
		else
			return 0.0;
		}
	 inline int intArg(int i) const
		{
		if (args.size() > i)
			return atoi(args[i].c_str());
		else
			return 0;
		}
	 inline bool boolArg(int i) const
		{
		if (args.size() <= i)
			return false;
		else if ((args[i] == "true") || (args[i] == "on") ||
		    (args[i] == "1"))
			return true;
		else
			return false;
		}
	 inline bool getVec2Args(pfVec2& v,int i=0) const
		{
		if (args.size() >= 2+i)
			{
			v[0] = atof(args[0+i].c_str());
			v[1] = atof(args[1+i].c_str());
			return true;
			}
		else
			return false;
		}
	 inline bool getVec3Args(pfVec3& v,int i=0) const
		{
		if (args.size() >= 3+i)
			{
			v[0] = atof(args[0+i].c_str());
			v[1] = atof(args[1+i].c_str());
			v[2] = atof(args[2+i].c_str());
			return true;
			}
		else
			return false;
		}
	 inline bool getVec4Args(pfVec4& v,int i=0) const
		{
		if (args.size() >= 4+i)
			{
			v[0] = atof(args[0+i].c_str());
			v[1] = atof(args[1+i].c_str());
			v[2] = atof(args[2+i].c_str());
			v[3] = atof(args[3+i].c_str());
			return true;
			}
		else
			return false;
		}

	 friend std::ostream& operator<<(std::ostream& s,const ygMessage& m);

	 ygMessage(void);
	 ~ygMessage(void);
	 ygMessage& operator=(const ygMessage&);
	 void parseString(const ygString& str,ygNode *n=NULL,const ygEvent* e=NULL);
	 void writeString(ygString& str) const;
	 void error(const ygString& prefix,const ygString& suffix="") const;
	private:
	 void replaceArgs(ygString& str,const ygEvent& event);
	 void splitMessageName(const ygString&,ygNode *);
	};

#endif
