// Revision: 11/01/01 Dave Pape

#include <stdlib.h>
#include "ygNodeDB.h"
#include "ygEvent.h"
#include "ygMessage.h"

using namespace std;


ygMessage::ygMessage(void)
	{
	delay = 0;
	node = NULL;
	}


ygMessage& ygMessage::operator=(const ygMessage& other)
	{
	message = other.message;
	args = other.args;
	node = other.node;
	nodeName = other.nodeName;
	delay = other.delay;
	return *this;
	}


ygMessage::~ygMessage(void)
	{
	}


ostream& operator<<(ostream& s,const ygMessage& m)
	{
	if (m.nodeName.length() > 0)
		s << m.nodeName << ".";
	s << m.message;
	if (m.args.size() > 0)
		{
		int i;
		s << "(";
		for (i=0; i < m.args.size()-1; i++)
			s << m.args[i] << ",";
		s << m.args[i] << ")";
		}
	if (m.delay > 0)
		s << "+" << m.delay;
	return s;
	}


void ygMessage::writeString(ygString& str) const
	{
	str.clear();
	if (nodeName.length() > 0)
		{
		str += nodeName;
		str += ".";
		}
	str += message;
	if (args.size() > 0)
		{
		int i;
		str += "(";
		for (i=0; i < args.size()-1; i++)
			{
			str += args[i];
			str += ",";
			}
		str += args[i];
		str += ")";
		}
	if (delay > 0)
		{
		char delayStr[32];
		sprintf(delayStr,"+%.4f",delay);
		str += delayStr;
		}
	}


#define SKIPWHITESPACE(s,i)  \
		{ if (i<s.length()) i = s.find_first_not_of(" \t",i); }

/* Parse a string, extracting individual pieces of message data
   (i.e. the node name, message name, argument list, and delay)
   The basic format of a message is:
	node.message(arg1, ..., argN)+delay
   where everything except 'message' is optional.  Arguments may
   be separated by whitespace or commas.
   Quotes may be used to enclose arguments which contain spaces or commas
   For example:
	foo
	foo()
	foo+1.5
	a.foo (1,2)		- args are '1' and '2'
	foo( 1 2 3) +7		- args are '1', '2', and '3'
	a.foo("1 2" 3)		- args are '1 2' and '3'
	foo ( b.bar( "1 2") 7 )	- args are 'b.bar( "1 2")' and '7'
*/
void ygMessage::parseString(const ygString& origstr,ygNode *n,const ygEvent* event)
	{
	ygString str(origstr);
	ygString tmpmsg;
	int i=0, next;
	if (event)
		replaceArgs(str,*event);
	delay = 0;
	SKIPWHITESPACE(str,i)
	next = str.find_first_of("()+, \t",i);
	tmpmsg.assign(str,i,next-i);
	i = next;
	splitMessageName(tmpmsg,n);
	SKIPWHITESPACE(str,i)
	if (str[i] == '(')
		{
		i++;
		SKIPWHITESPACE(str,i)
		while ((i < str.length()) && (str[i] != ')'))
			{
			ygString arg;
			if (str[i] == '"')
				{
				i++;
				while (str[i] != '"')
					{
					if (str[i] == '\\')
						i++;
					if (i < str.length())
						{
						arg += str[i];
						i++;
						}
					else
						break;
					}
				if ((i < str.length()) && (str[i] == '"'))
					i++;
				SKIPWHITESPACE(str,i)
				}
			else
				{
				int parenDepth=0;
				while ((i < str.length()) && ((parenDepth) ||
					(!strchr("), \t\"",str[i]))))
					{
					if (str[i] == '\\')
						i++;
					else if (str[i] == '(')
						parenDepth++;
					else if (str[i] == ')')
						parenDepth--;
					if (i < str.length())
						{
						arg += str[i];
						i++;
						}
					}
				if (parenDepth)
					cerr << "WARNING: unclosed parenthesis in message '"
						<< str << "'\n";
				SKIPWHITESPACE(str,i)
				}
			if ((i < str.length()) && (str[i] == ','))
				i++;
			/*  Remove any trailing whitespace from the argument */
			int tail = arg.find_last_not_of(" \t");
			if (tail < arg.length()-1)
				arg.erase(tail+1);
			args.push_back(arg);
			SKIPWHITESPACE(str,i)
			}
		if ((i < str.length()) && (str[i] == ')'))
			i++;
		}
	SKIPWHITESPACE(str,i)
	if ((i < str.length()) && (str[i] == '+'))
		delay = atof(str.c_str()+i+1);
	}


void ygMessage::splitMessageName(const ygString& m,ygNode *n)
	{
	int p = m.find('.');
	if (p != m.npos)
		{
		nodeName.assign(m,0,p);
		message.assign(m,p+1,m.length()-p-1);
		node = ygNodeDB::find(nodeName,false);
		}
	else
		{
		node = n;
		message = m;
		}
	}


void ygMessage::replaceArgs(ygString& str,const ygEvent& event)
	{
	int dollar = str.find('$');
	while (dollar != str.npos)
		{
		if (dollar == str.length()-1)
			break;
		else if (str[dollar+1] == '$')
			str.replace(dollar,2,"$");
		else
			{
			int end = str.find_first_of(" \t\".,+(){}",dollar);
			ygString arg;
			arg.assign(str,dollar+1,end-dollar-1);
			str.replace(dollar,end-dollar,event.argValue(arg));
			}
		dollar = str.find('$',dollar+1);
		}
	}


void ygMessage::error(const ygString& prefix,const ygString& suffix) const
	{
	cerr << "ERROR: " << prefix << " received bad message: "
		<< message << " " << suffix << endl;
	}
