#ifndef _ygFileRequest_h_
#define _ygFileRequest_h_

#include "ygString.h"

class ygFileRequest
	{
	public:
	 enum fileDirection { DOWNLOAD, UPLOAD };
	 ygFileRequest(const ygString& file,int direction=DOWNLOAD);
	 ygFileRequest(const ygString& localFile,const ygString& remoteFile,
	 		int direction=DOWNLOAD);
	 bool done(void) const;
	 bool failed(void) const;
	 const ygString& localFile(void) const;
	 const ygString& remoteFile(void) const;
	 int direction(void) const;
	private:
	 void setFailed(void);
	 void setLocalFile(const ygString&);
	 void setDone(void);
	 struct _ygFileRequestPrivateData * p_;
	 friend class ygFileServer;
	};

#endif
