// Revision: 11/01/01 Dave Pape

#include "ygFileServer.h"
#include "ygFileRequest.h"

using namespace std;

struct _ygFileRequestPrivateData
	{
	ygString localFile;
	ygString remoteFile;
	bool done;
	bool failed;
	int direction;
	};


ygFileRequest::ygFileRequest(const ygString& file, int direction)
	{
	p_ = new struct _ygFileRequestPrivateData;
	p_->localFile = file;
	p_->remoteFile = file;
	p_->done = false;
	p_->failed = false;
	p_->direction = direction;
	ygFileServer::queueRequest(this);
	}


ygFileRequest::ygFileRequest(const ygString& localFile,
			const ygString& remoteFile,int direction)
	{
	p_ = new struct _ygFileRequestPrivateData;
	p_->localFile = localFile;
	p_->remoteFile = remoteFile;
	p_->done = false;
	p_->failed = false;
	p_->direction = direction;
	ygFileServer::queueRequest(this);
	}


const ygString& ygFileRequest::localFile(void) const
	{
	return p_->localFile;
	}


const ygString& ygFileRequest::remoteFile(void) const
	{
	return p_->remoteFile;
	}


bool ygFileRequest::done(void) const
	{
	return p_->done;
	}


bool ygFileRequest::failed(void) const
	{
	return p_->failed;
	}


int ygFileRequest::direction(void) const
	{
	return p_->direction;
	}


void ygFileRequest::setFailed(void)
	{
	p_->failed = true;
	}


void ygFileRequest::setLocalFile(const ygString& localFile)
	{
	p_->localFile = localFile;
	}


void ygFileRequest::setDone(void)
	{
	p_->done = true;
	}
