// Revision: 11/01/01 Dave Pape

#include <stdlib.h>
#include <vector>
#include <map>
#include "ygWorld.h"
#include "ygEvent.h"
#include "ygMessage.h"
#include "ygEventMessages.h"

using namespace std;


typedef vector<ygString> messageList;


struct _ygEventMessagesPrivateData
	{
	map <ygString,messageList> eventMap;
	};



ygEventMessages::ygEventMessages(void)
	{
	p_ = new struct _ygEventMessagesPrivateData;
	ygnode_ = NULL;
	}


ygEventMessages::~ygEventMessages(void)
	{
	delete p_;
	}


void ygEventMessages::setNode(class ygNode* node)
	{
	ygnode_ = node;
	}


void ygEventMessages::clear(void)
	{
	map<ygString,messageList>::iterator iter;
	for (iter=p_->eventMap.begin(); iter != p_->eventMap.end(); ++iter)
		(*iter).second.clear();
	p_->eventMap.clear();
	}


void ygEventMessages::add(const ygString& event,const ygString& message)
	{
	p_->eventMap[event].push_back(message);
	}


void ygEventMessages::respondToEvent(const ygEvent& event) const
	{
	messageList::const_iterator iter;
	messageList& mapEntry = p_->eventMap[event.event];
	for (iter = mapEntry.begin(); iter != mapEntry.end(); ++iter)
		{
		ygMessage msg;
		msg.parseString(*iter,ygnode_,&event);
		ygWorld::World->scheduleMessage(msg);
		}
	}
