// Revision: 11/01/01 Dave Pape

#include <stdio.h>
#include <stdlib.h>
#include <map>
#include "ygEvent.h"

using namespace std;


struct _ygEventPrivateData
	{
	map<ygString,ygString*> args;
	};


ygEvent::ygEvent(const ygString& name,const ygString& args)
	{
	p_ = new struct _ygEventPrivateData;
	event = name;
	parseArgs(args);
	}


ygEvent& ygEvent::operator=(const ygEvent& other)
	{
	map<ygString,ygString*>::iterator iter;
	for (iter = p_->args.begin(); iter != p_->args.end(); ++iter)
		delete iter->second;
	p_->args.clear();
	for (iter = other.p_->args.begin(); iter != other.p_->args.end(); ++iter)
		p_->args[iter->first] = new ygString(*iter->second);
	return *this;
	}


ygEvent::~ygEvent(void)
	{
	map<ygString,ygString*>::iterator iter;
	for (iter = p_->args.begin(); iter != p_->args.end(); ++iter)
		delete iter->second;
	delete p_;
	}


const ygString& ygEvent::argValue(const ygString& a) const
	{
	return *(p_->args[a]);
	}


void ygEvent::addArg(const ygString& arg,const ygString& val)
	{
	p_->args[arg] = new ygString(val);
	}


#define SKIPWHITESPACE(s,i)  \
		{ if (i<s.length()) i = s.find_first_not_of(" \t",i); }

/* Parse a string, extracting the event name and any arguments.
   Format is: eventName [arg=val]*
   Spaces around the '=' are allowed.  'val' may be a quoted string in
   case it contains spaces.  'arg' must be a single string with no whitespace.
   Example strings:
	foo
	foo user=Dave grabber=Wand
	foo string = "blah blah"
*/
void ygEvent::parseArgs(const ygString& str)
	{
	int i=0, next;
	ygString arg,val;
	SKIPWHITESPACE(str,i)
	while (i < str.length())
		{
		next = str.find_first_of("= \t",i);
		arg.assign(str,i,next-i);
		i = next;
		SKIPWHITESPACE(str,i);
		if (str[i] == '=')
			{
			i++;
			SKIPWHITESPACE(str,i);
			if (str[i] == '"')
				{
				i++;
				next = str.find('"',i);
				}
			else
				next = str.find_first_of(" \t",i);
			val.assign(str,i,next-i);
			if (str[next] == '"')
				i = next + 1;
			else
				i = next;
			SKIPWHITESPACE(str,i);
			}
		else
			val.clear();
		addArg(arg,val);
		}
	}
