#ifndef _ygEnvironment_h_
#define _ygEnvironment_h_

#include "ygSpace.h"


class ygEnvironment : public ygSpace
	{
	public:
	 ygEnvironment(const char*,bool);
	 virtual ~ygEnvironment(void);
	 virtual void reset(void);
	 virtual void message(const ygMessage&);
	 virtual void app(void);
		 void setClip(float near,float far);
		 float nearClip(void) const;
		 float farClip(void) const;
		 void setSkyColor(const pfVec3&);
		 void setBackgroundMode (int mode);
		 const pfVec3& skyColor(void) const;
		 void setFog(int fogtype,const pfVec3& color,float onset,float opaque);
		 void fogOff(void);
		 void apply(void);
	protected:
	 virtual void acceptNetKey(const ygString&);
	private:
	 struct _ygEnvironmentPrivateData * p_;
	 static ygEnvironment * activeEnvironment_;
	};

extern "C" ygNode* construct_ygEnvironment(const char*,bool);


#endif
