// Revision: 11/01/01 Dave Pape

#include <stdlib.h>
#include <ctype.h>
#include <vector>
#include <map>
#include "ygDebugFlags.h"

using namespace std;


struct _ygDebugFlagsPrivateData
	{
	map<ygString,bool *> flags;
	};


ygDebugFlags::ygDebugFlags(void)
	{
	p_ = new struct _ygDebugFlagsPrivateData;
	}


ygDebugFlags::~ygDebugFlags(void)
	{
	delete p_;
	}


void ygDebugFlags::addFlag(const ygString& name, bool * var)
	{
	*var = false;
	p_->flags[name] = var;
	}


void ygDebugFlags::checkFlags(const ygString& prefix) const
	{
	ygString fullName;
	map<ygString,bool*>::const_iterator iter;
	for (iter=p_->flags.begin(); iter!=p_->flags.end(); ++iter)
		{
		fullName = prefix;
		fullName += ".";
		fullName += iter->first;
		/* Note: ONLY set the flag if checkDebugEnv returns true;
		  don't change the flag on false, because it may have been
		  previously set to true through a parent class name */
		if (checkDebugEnv(fullName))
			*(iter->second) = true;
		}
	}


void ygDebugFlags::checkFlag(const ygString& prefix,const ygString& name) const
	{
	bool * flag = p_->flags[name];
	if (flag)
		{
		ygString fullName(prefix);
		fullName += ".";
		fullName += name;
		if (checkDebugEnv(fullName))
			*flag = true;
		}
	}


void ygDebugFlags::setFlag(const ygString& flagname, bool val)
	{
	if (flagname == "*")
		{
		map<ygString,bool*>::const_iterator iter;
		for (iter=p_->flags.begin();
		     iter!=p_->flags.end(); ++iter)
			*(iter->second) = val;
		}
	else
		{
		bool * flag = p_->flags[flagname];
		if (flag)
			*flag = val;
		}
	}


bool ygDebugFlags::matchRegexp(const ygString& name,const ygString& opt)
	{
	int optPos=0, lastStar=-1, namePos=0;
	while ((namePos < name.length()) && (optPos < opt.length()))
		{
		while ((optPos < opt.length()) && (opt[optPos] == '*'))
			{
			optPos++;
			lastStar = optPos;
			}
		if (optPos == opt.length())
			break;
		if (tolower(name[namePos]) == tolower(opt[optPos]))
			{
			namePos++;
			optPos++;
			}
		else if (lastStar > -1)
			{
			namePos++;
			optPos = lastStar;
			}
		else
			return false;
		}
	if ((namePos >= name.length()) && (optPos >= opt.length()))
		return true;
	else if (lastStar == opt.length())
		return true;
	return false;
	}


bool ygDebugFlags::checkDebugEnv(const ygString& name)
	{
	static bool first=true;
	static vector<ygString*> opts;
	int i;
	if (first)
		{
		if (getenv("YG_DEBUG"))
			{
			ygString env = getenv("YG_DEBUG");
			ygString *opt;
			int i=0;
			while (opt = env.nextToken(" \t",&i))
				opts.push_back(opt);
			}
		first = false;
		}
	for (i=0; i < opts.size(); i++)
		if (ygDebugFlags::matchRegexp(name,*opts[i]))
			{
			return true;
			}
	return false;
	}
