#ifndef _ygDSOLoader_h_
#define _ygDSOLoader_h_

#include "ygString.h"
class ygNode;

typedef ygNode * (*ygNodeConstructorPtr)(const char*,bool);


class ygDSOLoader
	{
	public:
	 static void init(void);
	 static ygNodeConstructorPtr getNodeConstructor(const ygString&);
	private:
	 static void addBuiltinConstructors(void);
	 static void addConstructor(const ygString& name,
					ygNodeConstructorPtr constructor);
	 static void preLoadClasses(const ygString &classes);
	 static void searchForDSOs(void);
	 static void searchDirectory(const ygString& dirname);
	 static bool loadDSO(class ygDSOInfo *info);
	 static bool loadDSODependencies(const class ygDSOInfo *info);
	 static bool loadYgdepFileDependencies(const class ygDSOInfo *info);
	 static bool loadStringTagDependencies(const class ygDSOInfo *info);
	 static struct _ygDSOLoaderPrivateData * p_;
	};


#endif
