// Description: creates a wand that detects CAVE wand button events
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> this node can also be created with the alias: CAVEWand
//<li> this node should be a child of a <a href="ygCAVETracker.html">ygCAVETracker</a> node
//<li> this node is required for <a href="wandTrigger.html">wandTrigger</a> node detection
//<li> when pressed this node generates buttonX events where X is the button number
//<li> when released this node generates buttonUpX events where X is the button number
//</ul>
//
// Category: User
// Author: Dave Pape
// Revision: 11/01/01
//
#include <pfcave.h>
#include "ygCAVEWand.h"

extern "C" ygNode* construct_ygCAVEWand(const char* name,bool master) { return new ygCAVEWand(name,master); }

struct _ygCAVEWandPrivateData
	{
	int prevState[CAVE_MAX_BUTTONS];
	};


ygCAVEWand::ygCAVEWand(const char* name,bool master) : ygWand(name,master)
	{
	int i;
	setClassName("ygCAVEWand");
	p_ = new struct _ygCAVEWandPrivateData;
	for (i=0; i < CAVE_MAX_BUTTONS; i++)
		p_->prevState[i] = 0;
	}


void ygCAVEWand::reset(void)
	{
	int i;
	//for each CAVE button set the previous state to zero
	for (i=0; i < CAVE_MAX_BUTTONS; i++)
		p_->prevState[i] = 0;
	ygWand::reset();
	}


void ygCAVEWand::app(void)
	{
	int i;
	char flagName[16];
	//for each CAVE button
	for (i=0; i < CAVEController->num_buttons; i++)
		{
		//if button state becomes on then generate a button event
		if ((CAVEController->button[i]) && (!p_->prevState[i]))
			{
			sprintf(flagName,"button%d",i+1);
			setFlag(flagName);
			}
		//else, if button state becomes off then generate a buttonUp event
		else if (!(CAVEController->button[i]) && (p_->prevState[i]))
			{
			sprintf(flagName,"buttonUp%d",i+1);
			setFlag(flagName);
			}
		p_->prevState[i] = CAVEController->button[i];
		}
	ygWand::app();
	}
