// Description: establishes a view point for the CAVE library rendering
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> creates a tracked transform from CAVE sensor 0
//<li> added automatically to scene at startup unless the --noview option is used
//</ul>
//
// Category: Foundation
// Author: Dave Pape
//           11/01/01
// Revision: 05/01/03 Alex Hill - added setUser() method to use another user perspective
//
#include <pfcave.h>
#include "ygCAVEViewer.h"
#include "ygNodeDB.h"

extern "C" ygNode* construct_ygCAVEViewer(const char* name,bool master) { return new ygCAVEViewer(name,master); }


ygCAVEViewer::ygCAVEViewer(const char* name,bool master) : ygSimpleTransform(name,master)
	{
	setClassName("ygCAVEViewer");
	user = NULL;
	}


void ygCAVEViewer::app(void)
	{
	if (user && user->head())
		{
		pfMatrix mat;
		//get user navigation matrix
		user->getMatrix(mat);
		pfCoord coord;
		mat.getOrthoCoord(&coord);
		//update navigation data
		CAVENavLock();
		CAVENavLoadIdentity();
		CAVENavTranslate(coord.xyz.vec[0],coord.xyz.vec[1],coord.xyz.vec[2]);
		CAVENavRot(coord.hpr.vec[0],'z');
		CAVENavRot(coord.hpr.vec[1],'x');
		CAVENavRot(coord.hpr.vec[2],'y');
		CAVENavUnlock();
		//get user head matrix
		((ygSimpleTransform*)user->head())->getMatrix(mat);
		mat.getOrthoCoord(&coord);
		//update head sensor
		CAVESensor1->x = coord.xyz.vec[0];
 		CAVESensor1->y = coord.xyz.vec[1];
 		CAVESensor1->z = coord.xyz.vec[2];
 		CAVESensor1->azim = coord.hpr.vec[0];
 		CAVESensor1->elev = coord.hpr.vec[1];
 		CAVESensor1->roll = coord.hpr.vec[2];
		//get navigated head position
		user->head()->getTransform(mat);
		mat.getOrthoCoord(&coord);
		setPosition(coord.xyz);
		setOrientation(coord.hpr.vec[1],coord.hpr.vec[2],coord.hpr.vec[0]);
		}
	else
		{
		dontBroadcastNetKey("m");
		pfVec3 pos, ori;
		//get CAVE head position
		CAVEGetPosition(CAVE_HEAD_NAV, pos.vec);
		//get CAVE head orientation
		CAVEGetOrientation(CAVE_HEAD_NAV, ori.vec);
		//set the position and orientation of the transform
		setPosition(pos);
		setOrientation(ori);
		}
	ygSimpleTransform::app();
	}

void ygCAVEViewer::setUser(const ygString& userName)
	{
	ygMessage msg;
	msg.message = "updateInterval";
	msg.args.push_back("10.0");
	ygSimpleTransform::message(msg);
	user = (ygUser*)ygNodeDB::find(userName);	
	}

bool ygCAVEViewer::isCloned(ygNode* node)
	{
	if (node)
		{
		if (user == node)
			return true;
		else
			return false;
		}
	else
		{
		if (user)
			return true;
		else
			return false;
		}
	}

