// Description: creates a tracked simple transform from a CAVE sensor
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> this node can also be created with the alias: CAVETracker
//<li> this node will usually be a child of a <a href="ygUser.html">ygUser</a> node
//</ul>
//
// Category: User
// Author: Dave Pape
// Revision: 11/01/01
//
#include <pfcave.h>
#include "ygCAVETracker.h"

extern "C" ygNode* construct_ygCAVETracker(const char* name,bool master) { return new ygCAVETracker(name,master); }


ygCAVETracker::ygCAVETracker(const char* name,bool master) : ygSimpleTransform(name,master)
	{
	setClassName("ygCAVETracker");
	sensor_ = 0;
	}


void ygCAVETracker::reset(void)
	{
	//set sensor number to 0
	sensor_ = 0;
	ygSimpleTransform::reset();
	}


void ygCAVETracker::message(const ygMessage& msg)
	{
	//set the sensor number
	if (msg == "sensor")
		if (msg.args.size() > 0)
			setSensor(msg.intArg(0));
		else
			msg.error(name(),"(wrong number of arguments)");
	else
		ygSimpleTransform::message(msg);
	}


void ygCAVETracker::app(void)
	{
	pfVec3 pos, ori;
	//get the CAVE sensor position
	CAVEGetSensorPosition(CAVESENSOR(sensor_), CAVE_TRACKER_FRAME, pos.vec);
	//get the CAVE sensor orientation
	CAVEGetSensorOrientation(CAVESENSOR(sensor_), CAVE_TRACKER_FRAME, ori.vec);
	//set the position and orientation of the transform
	setPosition(pos);
	setOrientation(ori);
	ygSimpleTransform::app();
	}
