#ifndef _ygCAVENavigator_h_
#define _ygCAVENavigator_h_

#include "ygNavigator.h"

class ygCAVENavigator : public ygNavigator
	{
	public:
	 ygCAVENavigator(const char* name,bool master=true);
	 virtual void message(const ygMessage&);
	 virtual void reset(void);
	 virtual void app(void);
		 void setSpeed(float);
		 void setRotSpeed(float);
		 void setCollide(bool val=true);
		 void setFly(bool val=true);
		 void teleportTo(const pfVec3&);
		 void setHeading(float);
	 inline  float speed(void) const { return transSpeed_; }
	 inline  float rotSpeed(void) const { return rotSpeed_; }
	protected:
	 float rotSpeed_, transSpeed_, collideRadius_;
	 bool collide_, fly_;
	 pfVec3 prevCollidePos_;
	 void checkJoystick(void);
	 void checkCollision(void);
	 bool positionOK(pfVec3 pos);
	 void resetCollision(void);
	 void checkGround(void);
	};

extern "C" ygNode* construct_ygCAVENavigator(const char* name,bool master);

#endif
