// Description: creates a transform tracked with sensor 0 for the user head
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> this node can also be created with the alias: CAVEHead
//<li> this node should be a child of a <a href="ygUser.html">ygUser</a> node
//<li> sets the head of the user above it for use in collision detection and user detection
//<li> this node is required for walking navigation and collision detection
//</ul>
//
// Category: User
// Author: Dave Pape
// Revision: 11/01/01
//
#include <pfcave.h>
#include "ygUser.h"
#include "ygCAVEHead.h"

extern "C" ygNode* construct_ygCAVEHead(const char* name,bool master) { return new ygCAVEHead(name,master); }

struct _ygCAVEHeadPrivateData
	{
	ygUser* user;
	};


ygCAVEHead::ygCAVEHead(const char* name,bool master) : ygCAVETracker(name,master)
	{
	setClassName("ygCAVEHead");
	p_ = new struct _ygCAVEHeadPrivateData;
	p_->user = NULL;
	}


void ygCAVEHead::reset(void)
	{
	//find the user ancestor of this node
	p_->user = ygUser::findUserAncestor(this);
	//if found set user head to this node
	if (p_->user)
		p_->user->setHead(this);
	}


const ygUser* ygCAVEHead::user(void) const
	{
	return p_->user;
	}
