// Revision: 11/01/01 Dave Pape

#include "ygBox.h"

ygBox::ygBox(void)
	{
	pfBox::makeEmpty();
	}

ygBox::ygBox(const pfBox & box)
	{
	pfBox::min = box.min;
	pfBox::max = box.max;
	}


ygBox& ygBox::operator=(const pfBox & box)
	{
	pfBox::min = box.min;
	pfBox::max = box.max;
	return *this;
	}


float ygBox::sqrDistance(const pfVec3 & v) const
	{
	float dx,dy,dz;
	if (v[0] >= min[0])
		if (v[0] <= max[0])
			dx = 0;
		else
			dx = v[0] - max[0];
	else
		dx = min[0] - v[0];
	if (v[1] >= min[1])
		if (v[1] <= max[1])
			dy = 0;
		else
			dy = v[1] - max[1];
	else
		dy = min[1] - v[1];
	if (v[2] >= min[2])
		if (v[2] <= max[2])
			dz = 0;
		else
			dz = v[2] - max[2];
	else
		dz = min[2] - v[2];
	return dx*dx + dy*dy + dz*dz;
	}


int ygBox::contains(const pfVec3 &v) const
	{
	return pfBox::contains(v);
	}

int ygBox::isect(const pfSeg *s,float *d0,float *d1) const
	{
	return pfBox::isect(s,d0,d1);
	}

void ygBox::makeEmpty(void)
	{
	pfBox::makeEmpty();
	}

void ygBox::extendBy(const pfVec3 & v)
	{
	pfBox::extendBy(v);
	}

void ygBox::extendBy(const pfBox * box)
	{
	pfBox::extendBy(box);
	}

void ygBox::extendBy(const pfSphere * sph)
	{
	pfBox tmpbox;
	tmpbox.around(&sph,1);
	pfBox::extendBy(&tmpbox);
	}

void ygBox::extendBy(const pfCylinder * cyl)
	{
	pfBox tmpbox;
	tmpbox.around(&cyl,1);
	pfBox::extendBy(&tmpbox);
	}

void ygBox::around(const pfVec3 * vert,int nvert)
	{
	pfBox::around(vert,nvert);
	}

void ygBox::around(const pfBox ** boxes,int nboxes)
	{
	pfBox::around(boxes,nboxes);
	}

void ygBox::around(const pfSphere ** sph,int nsph)
	{
	pfBox::around(sph,nsph);
	}

void ygBox::around(const pfCylinder ** cyl,int ncyl)
	{
	pfBox::around(cyl,ncyl);
	}


float ygBox::size(void) const
	{
	pfVec3 delta = max - min;
	return delta.length()/2;
	}


int ygBox::volumeType(void) const
	{
	return YGVOL_BOX;
	}
