// Revision: 11/01/01 Dave Pape

#include <Performer/pf.h>
#include <Performer/pfdu.h>
#include <Performer/pr/pfGeoSet.h>
#include <Performer/pr/pfGeoState.h>
#include <Performer/pr/pfMaterial.h>
#include <Performer/pf/pfGeode.h>
#include <Performer/pf/pfGroup.h>
#include <Performer/pf/pfTraverser.h>
#include <math.h>


int transparencyType = PFTR_ON;

void traverseGraph(pfNode *node)
{
 int i;
 if (node->isOfType(pfGeode::getClassType()))
	{
	pfGeode *geode = (pfGeode *)node;
	for (i=0; i < geode->getNumGSets(); i++)
		{
		pfGeoSet *gset = geode->getGSet(i);
		gset->getGState()->setMode(PFSTATE_TRANSPARENCY, transparencyType);
		gset->setDrawBin(PFSORT_TRANSP_BIN);
		}
	}
 else if (node->isOfType(pfGroup::getClassType()))
	{
	pfGroup *group = (pfGroup *)node;
	for (i=0; i < group->getNumChildren(); i++)
		traverseGraph(group->getChild(i));
	}
}


main(int argc, char **argv)
{
 pfNode *node;
 int opt=1;

 if (argc < 3)
    {
	fprintf(stderr, "usage: %s infile outfile [blend]\n", argv[0]);
	exit(1);
    }

 if (argc > 3)
	{
	if (!strcasecmp(argv[3],"blend"))
		transparencyType = PFTR_BLEND_ALPHA;
	}

 pfInit();

 if (!(pfdInitConverter(argv[opt])))
	exit(1);
 if (!(pfdInitConverter(argv[opt+1])))
	exit(1);

 pfMultiprocess(0);
 pfConfig();

 node = pfdLoadFile(argv[opt]);

 traverseGraph(node);

 pfdStoreFile(node, argv[opt+1]);
}
