// Revision: 11/01/01 Dave Pape

#include <Performer/pf.h>
#include <Performer/pfdu.h>
#include <Performer/pf/pfSCS.h>
#include <math.h>

main(int argc, char **argv)
{
    pfNode *node;
 float xtrans=0,ytrans=0,ztrans=0;
 float xrot=0,yrot=0,zrot=0;
 float xscale=1,yscale=1,zscale=1;
 int opt=1,loop=1;
 pfCoord coord;
 pfMatrix matrix;
 pfSCS *scs;

    if (argc < 3)
    {
	fprintf(stderr, "usage: %s [-t xtrans ytrans ztrans] [-r xrot yrot zrot]\n"
		"\t[-s scale] [-s3 xscale yscale zscale]\n"
		"\tinfile outfile\n", argv[0]);
	exit(1);
    }

    pfInit();

    pfFilePath("/usr/share/Performer/data"
		":/usr/demos/models"
	        ":/usr/demos/data/flt"
		":/usr/demos/data/textures"
		);

 while (loop)
	{
	if (!strcmp(argv[opt],"-t"))
		{
		xtrans = atof(argv[++opt]);
		ytrans = atof(argv[++opt]);
		ztrans = atof(argv[++opt]);
		opt++;
		}
	else if (!strcmp(argv[opt],"-r"))
		{
		xrot = atof(argv[++opt]);
		yrot = atof(argv[++opt]);
		zrot = atof(argv[++opt]);
		opt++;
		}
	else if (!strcmp(argv[opt],"-s3"))
		{
		xscale = atof(argv[++opt]);
		yscale = atof(argv[++opt]);
		zscale = atof(argv[++opt]);
		opt++;
		}
	else if (!strcmp(argv[opt],"-s"))
		{
		xscale = yscale = zscale = atof(argv[++opt]);
		opt++;
		}
	else
		loop=0;
	}

    if (!(pfdInitConverter(argv[opt])))
	exit(1);
    if (!(pfdInitConverter(argv[opt+1])))
	exit(1);

    pfMultiprocess(0);

    pfConfig();

 coord.xyz.set(xtrans,ytrans,ztrans);
 coord.hpr.set(zrot,xrot,yrot);
 matrix.makeCoord(&coord);
 matrix.preScale(xscale,yscale,zscale,matrix);
 scs = new pfSCS(matrix);

    node = pfdLoadFile(argv[opt]);

 scs->addChild(node);

    scs->flatten(0);
    node = pfdCleanTree(scs, NULL);

    pfdStoreFile(node, argv[opt+1]);
}
