// Revision: 11/01/01 Dave Pape

#include <Performer/pf.h>
#include <Performer/pfdu.h>
#include <Performer/pr/pfGeoSet.h>
#include <Performer/pr/pfGeoState.h>
#include <Performer/pr/pfMaterial.h>
#include <Performer/pf/pfGeode.h>
#include <Performer/pf/pfGroup.h>
#include <Performer/pf/pfTraverser.h>
#include <math.h>



void traverseGraph(pfNode *node,int state)
{
 int i;
 if (node->isOfType(pfGeode::getClassType()))
	{
	pfGeode *geode = (pfGeode *)node;
	for (i=0; i < geode->getNumGSets(); i++)
		{
		pfGeoSet *gset = geode->getGSet(i);
		gset->getGState()->setMode(PFSTATE_CULLFACE,state);
		}
	}
 else if (node->isOfType(pfGroup::getClassType()))
	{
	pfGroup *group = (pfGroup *)node;
	for (i=0; i < group->getNumChildren(); i++)
		traverseGraph(group->getChild(i),state);
	}
}


main(int argc, char **argv)
{
 pfNode *node;
 int opt=1,loop=1;
 int state=PFCF_OFF;

 if (argc < 3)
    {
	fprintf(stderr, "usage: %s [-c (front|back)]\n"
		"\tinfile outfile\n", argv[0]);
	exit(1);
    }

 pfInit();
 
 while (loop)
	{
	if (!strcmp(argv[opt],"-c"))
		{
		opt++;
		if (!strcmp(argv[opt],"front"))
			state=PFCF_FRONT;
		else if (!strcmp(argv[opt],"back"))
			state=PFCF_BACK;
		opt++;
		}
	else
		loop=0;
	}

 if (!(pfdInitConverter(argv[opt])))
	exit(1);
 if (!(pfdInitConverter(argv[opt+1])))
	exit(1);

 pfMultiprocess(0);
 pfConfig();

 node = pfdLoadFile(argv[opt]);

 traverseGraph(node,state);

 pfdStoreFile(node, argv[opt+1]);
}
