// Revision: 11/01/01 Dave Pape

#include <Performer/pf.h>
#include <Performer/pfdu.h>
#include <Performer/pf/pfSCS.h>
#include <Performer/pf/pfGeode.h>
#include <Performer/pr/pfGeoSet.h>


pfBox getBoundingBox(pfNode *node);

static pfBox getGroupBoundingBox(pfGroup *group)
{
 pfBox box,cbox;
 int i;
 box.makeEmpty();
 for (i=0; i < group->getNumChildren(); i++)
	{
	cbox = getBoundingBox(group->getChild(i));
	box.extendBy(&cbox);
	}
 return box;
}

pfBox getBoundingBox(pfNode *node)
{
 pfBox box;
 box.makeEmpty();
 if (node->isOfType(pfGeode::getClassType()))
	{
	pfGeode *geode = (pfGeode *)node;
	int i;
	pfBox gbox;
	for (i=0; i < geode->getNumGSets(); i++)
		{
		geode->getGSet(i)->getBound(&gbox);
		box.extendBy(&gbox);
		}
	}
 else if (node->isOfType(pfSCS::getClassType()))
	{
	pfMatrix mat;
	box = getGroupBoundingBox((pfGroup *)node);
	((pfSCS *)node)->getMat(mat);
	box.xform(&box,mat);
	}
 else if (node->isOfType(pfGroup::getClassType()))
	box = getGroupBoundingBox((pfGroup *)node);
 return box;
}


main(int argc, char **argv)
{
 int i;
 pfNode *node;
 pfBox box;

 if (argc < 2)
    {
	fprintf(stderr, "usage: %s infile\n", argv[0]);
	exit(1);
    }

 pfInit();
 pfFilePath("/usr/share/Performer/data"
		":/usr/demos/models"
	        ":/usr/demos/data/flt"
		":/usr/demos/data/textures"
		);
 pfMultiprocess(0);
 pfConfig();
 pfNotifyLevel(PFNFY_INFO);

 for (i=1; i<argc; i++)
	{
	node = pfdLoadFile(argv[i]);
	pfdPrintSceneGraphStats(node,0.0);
	box = getBoundingBox(node);
	printf("%s:\n",argv[i]);
	printf("	X: %f - %f\n",box.min[0],box.max[0]);
	printf("	Y: %f - %f\n",box.min[1],box.max[1]);
	printf("	Z: %f - %f\n",box.min[2],box.max[2]);
	}
}
