/***********************************
*
* Ygdrasil 0.1.11-ats main.cxx
*
************************************/

// Revision: 
// 05/02/03 Alex Hill - added --viewer option for distributed applications
// 08/26/03 Ben Chang - added __ctype_b hack, shadows, disable SMP 

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <Performer/pf/pfChannel.h>
#include <Performer/pfdu.h>
#include <Performer/pfutil.h>
#include <Performer/pf/pfShadow.h>
#include <pfcave.h>
#include <CAVERN.hxx>
#include "ygNet.h"
#include "ygParser.h"
#include "ygWorld.h"
#include "ygNodeDB.h"
#include "ygNet.h"
#include "ygNode.h"
#include "ygUtil.h"
#include "ygUser.h"
#include "ygCAVEViewer.h"
#include "ygFileRequest.h"

using namespace std;

static void initGraphics(pfChannel *,void *);
static void checkNetMessages(void);
static void checkStdinMessages(void);
static void handleMessage(char *message);

static bool createView=true;
static bool quitFlag=false;

typedef struct
{
    pfShadow *shadow;
} SharedData;

static SharedData *Shared;

void printUsers(ygWorld *world)
	{
	int i,j;
	printf("\n%d users:\n",world->numUsers());
	for (i=0; i < world->numUsers(); i++)
		{
		ygUser *u = world->user(i);
		printf("  %s; ",u->name().c_str());
		printf("head=%p",u->head());
		if (u->head())
			printf("(%s)",u->head()->name().c_str());
		printf("; wands=");
		for (j=0; j < u->numWands(); j++)
			{
			printf(" %p",u->wand(j));
			if (u->wand(j))
				printf("(%s)",u->wand(j)->name().c_str());
			}
		printf("\n");
		}
	}


static void parseCommandLine(int argc,char **argv,ygWorld * world)
	{
	ygParser parser;
	int i;
	for (i=1; i < argc; i++)
		{
		if (!strncmp(argv[i],"--",2))
			{
			if (!strcasecmp(argv[i],"--noview"))
				createView = false;
			else if (!strcasecmp(argv[i],"--viewer"))
				((ygCAVEViewer*)world->viewer())->setUser(argv[++i]);
			else
				fprintf(stderr,"WARNING: unknown command line "
					"option '%s'\n",argv[i]);
			}
		else
			{
			parser.parseFile(argv[i],world->localRoot());
			}
		}
	}
	
// DrawChannel
static void DrawChannel (pfChannel *channel, void *)
{
    // erase framebuffer and draw Earth-Sky model 
    channel->clear();

    // call the draw fuction of the shadow class
    Shared->shadow->draw(channel);
    //ygWorld::World->pfshadow()->draw(channel);
    /*
    ygWorld::World->pfvolfog()->updateView();
    ygWorld::World->pfvolfog()->draw(channel);
    */
}


__const unsigned short int * __ctype_b;
__const __int32_t *__ctype_tolower;
__const __int32_t *__ctype_toupper;

void ctSetup ()
{
	__ctype_b = *(__ctype_b_loc());
	__ctype_toupper = *(__ctype_toupper_loc());
	__ctype_tolower = *(__ctype_tolower_loc());
}

int main(int argc,char **argv)
	{
	ygWorld *world;
	ygNode *root;
	
	ctSetup();
	
	setlinebuf(stdin);
	ygPrePFInit();
	pfInit();
	
	// get shared memory data for holding shadow caster 
	Shared = (SharedData*)pfCalloc(1, sizeof(SharedData), pfGetSharedArena());
	
	pfMultiprocess(PFMP_APPCULLDRAW);
	pfCAVEConfig(&argc,argv,NULL);
	CAVESetOption(CAVE_PROJ_INCLUDENAVIGATION, 1);
	ygPrePFConfig();
	pfConfig();
	pfCAVEInitChannels();
	ygNodeDB::init();
	world = new ygWorld;
	
	// set up shadow channel and channel draw function
	Shared->shadow = world->pfshadow();
	pfCAVEDrawFunc (DrawChannel);
	
	root = ygNodeDB::find("root");
	if (root)
		{
		printf("Found existing root node\n");
		world->setRoot(root);
		}
	else
		{
		printf("Creating new root node\n");
		world->createRoot();
		}
	parseCommandLine(argc,argv,world);
	world->reset();
	pfCAVEMasterChan()->setScene(world->pfscene());
	if (createView)
		{
		pfCAVEPreDrawFunc((pfChanFuncType)initGraphics);
		while ((!CAVEgetbutton(CAVE_ESCKEY)) && (!quitFlag))
			{
			pfCAVEPreFrame();
			world->updateShadows();
			pfFrame();
			pfCAVEPostFrame();
			pfCAVEPreDrawFunc(NULL);
			world->frame();
			checkNetMessages();
			checkStdinMessages();
			if (CAVEgetbutton(CAVE_RKEY))
				world->reset();
			if (CAVEgetbutton(CAVE_GKEY))
				{
				ygPrintSceneGraph(world->root());
				printUsers(world);
				}
			pfSync();
			}
		}
	else
		{
		bool doSleep = false;
		if (getenv("YG_SERVER_DO_SLEEP"))
			doSleep = true;
		ygSetServerMode();
		while (!quitFlag)
			{
			checkNetMessages();
			checkStdinMessages();
			world->frame();
			if (doSleep)
				usleep(1000);
			}
		}
	world->unlinkLocalScene();
	ygNet::halt();
	delete world;
	pfFree(Shared);
	pfCAVEHalt();
	pfuExitUtil();
	pfuExitInput();
	pfExit();
	return 0;
	}


static void initGraphics(pfChannel *chan,void *)
	{
	/* This is needed to keep it from crashing an Impact when the textures
	  exceed texture memory */
	int i,size;
	static int first=1;
	if (first)
		{
		pfList *texList = pfuMakeSceneTexList(chan->getScene());
		if (getenv("YG_PF_SHOW_TEXTURES"))
			pfuDownloadTexList(texList, PFUTEX_SHOW);
		else
			pfuDownloadTexList(texList, PFUTEX_APPLY);
		for (i=0, size=0; i < texList->getNum(); i++)
			size += pfuGetTexSize((pfTexture *) texList->get(i));
		printf("TOTAL TEXTURE SIZE: %d bytes\n",size);
		first = 0;
		}
	}


static void checkStdinMessages(void)
	{
	fd_set readfds;
	struct timeval timeout;
	timeout.tv_sec = 0;
	timeout.tv_usec = 0;
	FD_ZERO(&readfds);
	FD_SET(0, &readfds);
	if (select(1,&readfds,NULL,NULL,&timeout))
		{
		if (FD_ISSET(0,&readfds))
			{
			char line[512];
			fgets(line,sizeof(line),stdin);
			if ((strlen(line)>0) && (line[strlen(line)-1] == '\n'))
				line[strlen(line)-1] = '\0';
			handleMessage(line);
			}
		}
	}


static void checkNetMessages(void)
	{
	static CAVERNnet_udp_c *sock = NULL;
	if (!sock)
		{
		sock = new CAVERNnet_udp_c;
		sock->init(1967);
		sock->makeNonBlocking();
		}
	char message[1024];
	while (sock->receive(message,sizeof(message)) > 0)
		{
		printf("received message '%s'\n",message);
		handleMessage(message);
		}
	}


static bool allWhiteSpace(char *s)
	{
	while (*s)
		if (!isspace(*s))
			return false;
		else
			s++;
	return true;
	}


static void handleMessage(char *message)
	{
	if (allWhiteSpace(message))
		return;
	if (strncasecmp(message,"texcheck",8) == 0)
		{
		char name[512];
		sscanf(message,"%*s%s",name);
		ygNode * node = ygNodeDB::find(name,false);
		if (node)
			{
			int i,size=0;
			pfList * texList = pfuMakeTexList(node->pfnode());
			for (i=0, size=0; i < texList->getNum(); i++)
				size += pfuGetTexSize((pfTexture *) texList->get(i));
			printf("%s has %d textures, total size = %d bytes\n",name,i,size);
			}
		}
	else if (strcasecmp(message,"stats") == 0)
		ygWorld::World->root()->printTimingStats();
	else if (strcasecmp(message,"netstats") == 0)
		ygNet::showStats();
	else if (strcasecmp(message,"graph") == 0)
		ygPrintSceneGraph(ygWorld::World->root());
	else if (strcasecmp(message,"netreset") == 0)
		ygNet::reset();
	else if ((strcasecmp(message,"quit") == 0) || (strcasecmp(message,"exit") == 0))
		quitFlag = true;
	else
		{
		ygMessage msg;
		msg.parseString(message,NULL,NULL);
		ygWorld::World->scheduleMessage(msg);
		}
	}
