#include <string.h>
#include <stdio.h>
#include <malloc.h>
#include "ygrepeaterQueue.h"

#if 1
#define GET_WRITE_POINT(v) \
	{ pthread_mutex_lock(&wmutex_); v = writePoint_; pthread_mutex_unlock(&wmutex_); }
#define SET_WRITE_POINT(v) \
	{ pthread_mutex_lock(&wmutex_); writePoint_ = v; pthread_mutex_unlock(&wmutex_); }
#define GET_READ_POINT(v) \
	{ pthread_mutex_lock(&rmutex_); v = readPoint_; pthread_mutex_unlock(&rmutex_); }
#define SET_READ_POINT(v) \
	{ pthread_mutex_lock(&rmutex_); readPoint_ = v; pthread_mutex_unlock(&rmutex_); }

#else
#define GET_WRITE_POINT(v) \
	{  v = writePoint_; }
#define SET_WRITE_POINT(v) \
	{  writePoint_ = v; }
#define GET_READ_POINT(v) \
	{  v = readPoint_;  }
#define SET_READ_POINT(v) \
	{  readPoint_ = v;  }
#endif

ygrepeaterQueue::ygrepeaterQueue(size_t size)
	{
	bufferSize_ = size;
	buffer_ = (char *) malloc(size);
	if (!buffer_)
		{
		perror("malloc");
		fprintf(stderr,"ygrepeater failed to malloc %d bytes\n",size);
		bufferSize_ = 0;
		}
	readPoint_ = 0;
	writePoint_ = 0;
	pthread_mutex_init(&rmutex_,NULL);
	pthread_mutex_init(&wmutex_,NULL);
	}


void ygrepeaterQueue::add(void *data,size_t size)
	{
	size_t wp,rp;
	GET_WRITE_POINT(wp)
	GET_READ_POINT(rp)
	size_t freeBytes, totalSize;
/* Check how many bytes of space are available to write into */
	if (wp >= rp)
		freeBytes = bufferSize_ - wp + rp;
	else
		freeBytes = rp - wp;
	totalSize = size + sizeof(size_t);
	if (freeBytes < totalSize)
		return;
/* Put packet size into buffer */
	wp = writeBytes(&size,sizeof(size_t),wp);
/* Put packet into buffer */
	wp = writeBytes(data,size,wp);
	SET_WRITE_POINT(wp);
	}


size_t ygrepeaterQueue::writeBytes(void *data,size_t size,int wp)
	{
/* If the chunk of data will wrap past the end of the buffer, break it into 2 parts */
	if (wp + size > bufferSize_)
		{
		int firstFragmentSize = bufferSize_ - wp;
		char *cdata = (char *)data;
		memcpy(buffer_+wp, data, firstFragmentSize);
		memcpy(buffer_, cdata+firstFragmentSize, size - firstFragmentSize);
		}
/* Otherwise, just write it all at once */
	else
		{
		memcpy(buffer_+wp, data, size);
		}
	return (wp + size) % bufferSize_;
	}


size_t ygrepeaterQueue::get(void *data,size_t *size,size_t maxDataSize)
	{
	size_t wp,rp;
	GET_WRITE_POINT(wp)
	GET_READ_POINT(rp)
	size_t availableBytes;
/* Check how many bytes of data are available to read */
	if (wp >= rp)
		availableBytes = wp - rp;
	else
		availableBytes = bufferSize_ - rp + wp;
	if (availableBytes < sizeof(size_t))
		{
		*size = 0;
		return 0;
		}
/* Get the size of the next packet */
	rp = readBytes(size,sizeof(size_t),rp);
	availableBytes -= sizeof(size_t);
/* Make sure enough data is really available - hopefully this should never fail */
	if (availableBytes < *size)
		{
		fprintf(stderr,"ERROR: ygrepeaterQueue has lost some data - buffer is probably mangled\n");
		*size = 0;
		return 0;
		}
/* Get the packet data */
	rp = readBytes(data,*size,rp);
	SET_READ_POINT(rp);
	return *size;
	}


size_t ygrepeaterQueue::readBytes(void *data,size_t size,int rp)
	{
/* If the chunk of data wraps past the end of the buffer, read it in 2 parts */
	if (rp + size > bufferSize_)
		{
		int firstFragmentSize = bufferSize_ - rp;
		char *cdata = (char *)data;
		memcpy(data, buffer_+rp, firstFragmentSize);
		memcpy(cdata+firstFragmentSize, buffer_, size - firstFragmentSize);
		}
/* Otherwise, just read it all at once */
	else
		{
		memcpy(data, buffer_+rp, size);
		}
	return (rp + size) % bufferSize_;
	}
